rule win_mailto_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.mailto."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.mailto"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8bc8 83c408 85c9 7412 a1???????? }
            // n = 5, score = 400
            //   8bc8                 | mov                 ecx, eax
            //   83c408               | add                 esp, 8
            //   85c9                 | test                ecx, ecx
            //   7412                 | je                  0x14
            //   a1????????           |                     

        $sequence_1 = { 8d8424d4000000 50 8d442440 50 e8???????? 8d442444 50 }
            // n = 7, score = 400
            //   8d8424d4000000       | lea                 eax, [esp + 0xd4]
            //   50                   | push                eax
            //   8d442440             | lea                 eax, [esp + 0x40]
            //   50                   | push                eax
            //   e8????????           |                     
            //   8d442444             | lea                 eax, [esp + 0x44]
            //   50                   | push                eax

        $sequence_2 = { c744246072006900 c744246476006900 c74424686c006500 c744246c67006500 6689442470 6a10 }
            // n = 6, score = 400
            //   c744246072006900     | mov                 dword ptr [esp + 0x60], 0x690072
            //   c744246476006900     | mov                 dword ptr [esp + 0x64], 0x690076
            //   c74424686c006500     | mov                 dword ptr [esp + 0x68], 0x65006c
            //   c744246c67006500     | mov                 dword ptr [esp + 0x6c], 0x650067
            //   6689442470           | mov                 word ptr [esp + 0x70], ax
            //   6a10                 | push                0x10

        $sequence_3 = { 8b4c241c 660f1f840000000000 8bc3 81e3ffffff03 c1f81a 0344242c }
            // n = 6, score = 400
            //   8b4c241c             | mov                 ecx, dword ptr [esp + 0x1c]
            //   660f1f840000000000     | nop    word ptr [eax + eax]
            //   8bc3                 | mov                 eax, ebx
            //   81e3ffffff03         | and                 ebx, 0x3ffffff
            //   c1f81a               | sar                 eax, 0x1a
            //   0344242c             | add                 eax, dword ptr [esp + 0x2c]

        $sequence_4 = { 83f804 57 0f44d9 e8???????? 83c404 85db 747d }
            // n = 7, score = 400
            //   83f804               | cmp                 eax, 4
            //   57                   | push                edi
            //   0f44d9               | cmove               ebx, ecx
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   85db                 | test                ebx, ebx
            //   747d                 | je                  0x7f

        $sequence_5 = { 56 8b742428 56 8b4034 ffd0 83c408 85c0 }
            // n = 7, score = 400
            //   56                   | push                esi
            //   8b742428             | mov                 esi, dword ptr [esp + 0x28]
            //   56                   | push                esi
            //   8b4034               | mov                 eax, dword ptr [eax + 0x34]
            //   ffd0                 | call                eax
            //   83c408               | add                 esp, 8
            //   85c0                 | test                eax, eax

        $sequence_6 = { 2b442410 83c003 50 e8???????? 83c404 89442410 85c0 }
            // n = 7, score = 400
            //   2b442410             | sub                 eax, dword ptr [esp + 0x10]
            //   83c003               | add                 eax, 3
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   89442410             | mov                 dword ptr [esp + 0x10], eax
            //   85c0                 | test                eax, eax

        $sequence_7 = { 53 55 56 8b742420 33db 85f6 0f84a0000000 }
            // n = 7, score = 400
            //   53                   | push                ebx
            //   55                   | push                ebp
            //   56                   | push                esi
            //   8b742420             | mov                 esi, dword ptr [esp + 0x20]
            //   33db                 | xor                 ebx, ebx
            //   85f6                 | test                esi, esi
            //   0f84a0000000         | je                  0xa6

        $sequence_8 = { e8???????? 83c40c c7400c00000000 8d4705 5f }
            // n = 5, score = 400
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   c7400c00000000       | mov                 dword ptr [eax + 0xc], 0
            //   8d4705               | lea                 eax, [edi + 5]
            //   5f                   | pop                 edi

        $sequence_9 = { 53 8b2cb0 e8???????? 50 53 ff7504 e8???????? }
            // n = 7, score = 400
            //   53                   | push                ebx
            //   8b2cb0               | mov                 ebp, dword ptr [eax + esi*4]
            //   e8????????           |                     
            //   50                   | push                eax
            //   53                   | push                ebx
            //   ff7504               | push                dword ptr [ebp + 4]
            //   e8????????           |                     

    condition:
        7 of them and filesize < 180224
}