rule win_mangzamel_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.mangzamel."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.mangzamel"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d5e64 33ff 8bcb 897dfc e8???????? }
            // n = 5, score = 400
            //   8d5e64               | lea                 ebx, [esi + 0x64]
            //   33ff                 | xor                 edi, edi
            //   8bcb                 | mov                 ecx, ebx
            //   897dfc               | mov                 dword ptr [ebp - 4], edi
            //   e8????????           |                     

        $sequence_1 = { 85c0 7434 8b8e8c000000 8908 eb2a 8b4510 802000 }
            // n = 7, score = 400
            //   85c0                 | test                eax, eax
            //   7434                 | je                  0x36
            //   8b8e8c000000         | mov                 ecx, dword ptr [esi + 0x8c]
            //   8908                 | mov                 dword ptr [eax], ecx
            //   eb2a                 | jmp                 0x2c
            //   8b4510               | mov                 eax, dword ptr [ebp + 0x10]
            //   802000               | and                 byte ptr [eax], 0

        $sequence_2 = { 8b4008 8945b8 8b4dd8 57 8d45a8 57 50 }
            // n = 7, score = 400
            //   8b4008               | mov                 eax, dword ptr [eax + 8]
            //   8945b8               | mov                 dword ptr [ebp - 0x48], eax
            //   8b4dd8               | mov                 ecx, dword ptr [ebp - 0x28]
            //   57                   | push                edi
            //   8d45a8               | lea                 eax, [ebp - 0x58]
            //   57                   | push                edi
            //   50                   | push                eax

        $sequence_3 = { 8975f0 c706???????? c745fc02000000 e8???????? 8d8e88000000 c645fc01 }
            // n = 6, score = 400
            //   8975f0               | mov                 dword ptr [ebp - 0x10], esi
            //   c706????????         |                     
            //   c745fc02000000       | mov                 dword ptr [ebp - 4], 2
            //   e8????????           |                     
            //   8d8e88000000         | lea                 ecx, [esi + 0x88]
            //   c645fc01             | mov                 byte ptr [ebp - 4], 1

        $sequence_4 = { 8d440103 c3 56 57 8b7c2410 6a68 6a00 }
            // n = 7, score = 400
            //   8d440103             | lea                 eax, [ecx + eax + 3]
            //   c3                   | ret                 
            //   56                   | push                esi
            //   57                   | push                edi
            //   8b7c2410             | mov                 edi, dword ptr [esp + 0x10]
            //   6a68                 | push                0x68
            //   6a00                 | push                0

        $sequence_5 = { ffb18c000000 50 6802501333 eb32 8b01 ff5038 eb30 }
            // n = 7, score = 400
            //   ffb18c000000         | push                dword ptr [ecx + 0x8c]
            //   50                   | push                eax
            //   6802501333           | push                0x33135002
            //   eb32                 | jmp                 0x34
            //   8b01                 | mov                 eax, dword ptr [ecx]
            //   ff5038               | call                dword ptr [eax + 0x38]
            //   eb30                 | jmp                 0x32

        $sequence_6 = { 834dfcff 8d8db8fdffff e8???????? 8b4df4 b001 5e 64890d00000000 }
            // n = 7, score = 400
            //   834dfcff             | or                  dword ptr [ebp - 4], 0xffffffff
            //   8d8db8fdffff         | lea                 ecx, [ebp - 0x248]
            //   e8????????           |                     
            //   8b4df4               | mov                 ecx, dword ptr [ebp - 0xc]
            //   b001                 | mov                 al, 1
            //   5e                   | pop                 esi
            //   64890d00000000       | mov                 dword ptr fs:[0], ecx

        $sequence_7 = { 51 50 e8???????? 8bf0 59 3bf3 59 }
            // n = 7, score = 400
            //   51                   | push                ecx
            //   50                   | push                eax
            //   e8????????           |                     
            //   8bf0                 | mov                 esi, eax
            //   59                   | pop                 ecx
            //   3bf3                 | cmp                 esi, ebx
            //   59                   | pop                 ecx

        $sequence_8 = { 83ea00 7421 4a 7412 4a }
            // n = 5, score = 400
            //   83ea00               | sub                 edx, 0
            //   7421                 | je                  0x23
            //   4a                   | dec                 edx
            //   7412                 | je                  0x14
            //   4a                   | dec                 edx

        $sequence_9 = { e8???????? 51 56 57 8b7d08 85ff }
            // n = 6, score = 400
            //   e8????????           |                     
            //   51                   | push                ecx
            //   56                   | push                esi
            //   57                   | push                edi
            //   8b7d08               | mov                 edi, dword ptr [ebp + 8]
            //   85ff                 | test                edi, edi

    condition:
        7 of them and filesize < 360448
}