rule win_mars_stealer_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.mars_stealer."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.mars_stealer"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 894508 8b4d08 8b550c 8a02 8801 }
            // n = 5, score = 100
            //   894508               | mov                 dword ptr [ebp + 8], eax
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   8b550c               | mov                 edx, dword ptr [ebp + 0xc]
            //   8a02                 | mov                 al, byte ptr [edx]
            //   8801                 | mov                 byte ptr [ecx], al

        $sequence_1 = { 51 e8???????? 83c418 8d95b0fdffff }
            // n = 4, score = 100
            //   51                   | push                ecx
            //   e8????????           |                     
            //   83c418               | add                 esp, 0x18
            //   8d95b0fdffff         | lea                 edx, [ebp - 0x250]

        $sequence_2 = { 83c404 8b4df0 c7414800000000 8b55f0 837a3c00 7416 }
            // n = 6, score = 100
            //   83c404               | add                 esp, 4
            //   8b4df0               | mov                 ecx, dword ptr [ebp - 0x10]
            //   c7414800000000       | mov                 dword ptr [ecx + 0x48], 0
            //   8b55f0               | mov                 edx, dword ptr [ebp - 0x10]
            //   837a3c00             | cmp                 dword ptr [edx + 0x3c], 0
            //   7416                 | je                  0x18

        $sequence_3 = { 8d8598faffff 50 e8???????? 83c418 8b4d1c 51 }
            // n = 6, score = 100
            //   8d8598faffff         | lea                 eax, [ebp - 0x568]
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c418               | add                 esp, 0x18
            //   8b4d1c               | mov                 ecx, dword ptr [ebp + 0x1c]
            //   51                   | push                ecx

        $sequence_4 = { c705????????ac304100 68???????? e8???????? 83c404 a3???????? 68???????? e8???????? }
            // n = 7, score = 100
            //   c705????????ac304100     |     
            //   68????????           |                     
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   a3????????           |                     
            //   68????????           |                     
            //   e8????????           |                     

        $sequence_5 = { 55 8bec c705????????ac304100 c705????????c4304100 c705????????d4304100 c705????????e4304100 }
            // n = 6, score = 100
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   c705????????ac304100     |     
            //   c705????????c4304100     |     
            //   c705????????d4304100     |     
            //   c705????????e4304100     |     

        $sequence_6 = { 8b551c 52 e8???????? 83c410 6a04 8d45f8 50 }
            // n = 7, score = 100
            //   8b551c               | mov                 edx, dword ptr [ebp + 0x1c]
            //   52                   | push                edx
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10
            //   6a04                 | push                4
            //   8d45f8               | lea                 eax, [ebp - 8]
            //   50                   | push                eax

        $sequence_7 = { 68???????? 8b0d???????? 51 ff15???????? 8b95e4fcffff 52 ff15???????? }
            // n = 7, score = 100
            //   68????????           |                     
            //   8b0d????????         |                     
            //   51                   | push                ecx
            //   ff15????????         |                     
            //   8b95e4fcffff         | mov                 edx, dword ptr [ebp - 0x31c]
            //   52                   | push                edx
            //   ff15????????         |                     

        $sequence_8 = { 8d8d78ecffff 51 e8???????? 8d95e4d7ffff 52 8d85e0d7ffff 50 }
            // n = 7, score = 100
            //   8d8d78ecffff         | lea                 ecx, [ebp - 0x1388]
            //   51                   | push                ecx
            //   e8????????           |                     
            //   8d95e4d7ffff         | lea                 edx, [ebp - 0x281c]
            //   52                   | push                edx
            //   8d85e0d7ffff         | lea                 eax, [ebp - 0x2820]
            //   50                   | push                eax

        $sequence_9 = { 8bec b8c81f0000 e8???????? c745f0a01f0000 c745ec00000000 c78544e0ffff9e304100 }
            // n = 6, score = 100
            //   8bec                 | mov                 ebp, esp
            //   b8c81f0000           | mov                 eax, 0x1fc8
            //   e8????????           |                     
            //   c745f0a01f0000       | mov                 dword ptr [ebp - 0x10], 0x1fa0
            //   c745ec00000000       | mov                 dword ptr [ebp - 0x14], 0
            //   c78544e0ffff9e304100     | mov    dword ptr [ebp - 0x1fbc], 0x41309e

    condition:
        7 of them and filesize < 219136
}