rule win_matrix_banker_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.matrix_banker."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.matrix_banker"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d4a9f 80f905 7705 80c2a9 }
            // n = 4, score = 900
            //   8d4a9f               | je                  0x185c
            //   80f905               | dec                 esp
            //   7705                 | lea                 eax, [eax + 1]
            //   80c2a9               | test                eax, eax

        $sequence_1 = { eb16 8d489f 80f905 7704 04a9 eb0a }
            // n = 6, score = 900
            //   eb16                 | call                dword ptr [ecx + 0x14]
            //   8d489f               | mov                 eax, dword ptr [ebx]
            //   80f905               | lea                 edx, [ebp - 0xc]
            //   7704                 | push                0
            //   04a9                 | push                edx
            //   eb0a                 | call                dword ptr [ecx + 0x14]

        $sequence_2 = { 8d489f 80f905 7704 04a9 eb0a 8d48bf }
            // n = 6, score = 900
            //   8d489f               | je                  0x17f3
            //   80f905               | dec                 esp
            //   7704                 | mov                 edi, dword ptr [esp + 0x40]
            //   04a9                 | dec                 eax
            //   eb0a                 | test                edi, edi
            //   8d48bf               | je                  0x18bb

        $sequence_3 = { 04a9 eb0a 8d48bf 80f905 }
            // n = 4, score = 900
            //   04a9                 | add                 al, 0x5c
            //   eb0a                 | add                 al, 0x4c
            //   8d48bf               | out                 0xb2, al
            //   80f905               | add                 al, 0x23

        $sequence_4 = { e8???????? 85c0 740a e8???????? 83f8ff }
            // n = 5, score = 900
            //   e8????????           |                     
            //   85c0                 | cmp                 edx, 0x100
            //   740a                 | jae                 0x8ac
            //   e8????????           |                     
            //   83f8ff               | mov                 al, byte ptr [edi + 0x3794708]

        $sequence_5 = { eb0a 8d48bf 80f905 7702 04c9 8d4ad0 80f909 }
            // n = 7, score = 900
            //   eb0a                 | mov                 edx, dword ptr [esp + 0x60]
            //   8d48bf               | dec                 ebp
            //   80f905               | test                edi, edi
            //   7702                 | je                  0x1eb4
            //   04c9                 | dec                 ecx
            //   8d4ad0               | test                eax, ebx
            //   80f909               | je                  0x1f1c

        $sequence_6 = { 8d4abf 80f905 7703 80c2c9 }
            // n = 4, score = 900
            //   8d4abf               | je                  0x1978
            //   80f905               | mov                 edx, dword ptr [ebp - 0xb0]
            //   7703                 | mov                 dword ptr [ebp - 0xb8], edx
            //   80c2c9               | test                eax, eax

        $sequence_7 = { eb18 8d4a9f 80f905 7705 80c2a9 eb0b 8d4abf }
            // n = 7, score = 900
            //   eb18                 | xor                 eax, eax
            //   8d4a9f               | dec                 eax
            //   80f905               | lea                 edx, [esp + 0x48]
            //   7705                 | nop                 
            //   80c2a9               | dec                 ecx
            //   eb0b                 | add                 dword ptr [esi + 8], 0x20
            //   8d4abf               | dec                 eax

        $sequence_8 = { 80f905 7704 04a9 eb0a 8d48bf }
            // n = 5, score = 900
            //   80f905               | dec                 eax
            //   7704                 | mov                 dword ptr [ebp - 0x48], esi
            //   04a9                 | call                dword ptr [eax + 0x28]
            //   eb0a                 | cmp                 ebx, dword ptr [ebp - 0x48]
            //   8d48bf               | jne                 0x1f5a

        $sequence_9 = { 8d4a9f 80f905 7705 80c2a9 eb0b 8d4abf }
            // n = 6, score = 900
            //   8d4a9f               | mov                 dword ptr [esp + 0x30], ecx
            //   80f905               | mov                 dword ptr [esp + 0x48], 1
            //   7705                 | dec                 eax
            //   80c2a9               | mov                 dword ptr [esp + 0x38], eax
            //   eb0b                 | dec                 esp
            //   8d4abf               | mov                 edx, dword ptr [ebp + 0x4f8]

    condition:
        7 of them and filesize < 422912
}