rule win_megumin_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.megumin."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.megumin"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 4f 83c404 33c9 ba10000000 83ff03 771a }
            // n = 7, score = 200
            //   e8????????           |                     
            //   4f                   | dec                 edi
            //   83c404               | add                 esp, 4
            //   33c9                 | xor                 ecx, ecx
            //   ba10000000           | mov                 edx, 0x10
            //   83ff03               | cmp                 edi, 3
            //   771a                 | ja                  0x1c

        $sequence_1 = { 51 e8???????? 83c40c 8d4344 6803010000 ffb558feffff 6804010000 }
            // n = 7, score = 200
            //   51                   | push                ecx
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   8d4344               | lea                 eax, [ebx + 0x44]
            //   6803010000           | push                0x103
            //   ffb558feffff         | push                dword ptr [ebp - 0x1a8]
            //   6804010000           | push                0x104

        $sequence_2 = { 2bf9 8b8d88feffff 8bc2 2bc1 57 3bf8 7734 }
            // n = 7, score = 200
            //   2bf9                 | sub                 edi, ecx
            //   8b8d88feffff         | mov                 ecx, dword ptr [ebp - 0x178]
            //   8bc2                 | mov                 eax, edx
            //   2bc1                 | sub                 eax, ecx
            //   57                   | push                edi
            //   3bf8                 | cmp                 edi, eax
            //   7734                 | ja                  0x36

        $sequence_3 = { 83fa38 57 0f43c1 8bce 50 }
            // n = 5, score = 200
            //   83fa38               | cmp                 edx, 0x38
            //   57                   | push                edi
            //   0f43c1               | cmovae              eax, ecx
            //   8bce                 | mov                 ecx, esi
            //   50                   | push                eax

        $sequence_4 = { c745bc00000000 6a00 8d4db0 c645fc03 e8???????? 6a24 }
            // n = 6, score = 200
            //   c745bc00000000       | mov                 dword ptr [ebp - 0x44], 0
            //   6a00                 | push                0
            //   8d4db0               | lea                 ecx, [ebp - 0x50]
            //   c645fc03             | mov                 byte ptr [ebp - 4], 3
            //   e8????????           |                     
            //   6a24                 | push                0x24

        $sequence_5 = { 83ef01 75d9 6a40 8d4e01 57 51 }
            // n = 6, score = 200
            //   83ef01               | sub                 edi, 1
            //   75d9                 | jne                 0xffffffdb
            //   6a40                 | push                0x40
            //   8d4e01               | lea                 ecx, [esi + 1]
            //   57                   | push                edi
            //   51                   | push                ecx

        $sequence_6 = { 0f85cf000000 83bd60ffffff10 8d8d4cffffff 8b955cffffff 0f438d4cffffff 6a04 68???????? }
            // n = 7, score = 200
            //   0f85cf000000         | jne                 0xd5
            //   83bd60ffffff10       | cmp                 dword ptr [ebp - 0xa0], 0x10
            //   8d8d4cffffff         | lea                 ecx, [ebp - 0xb4]
            //   8b955cffffff         | mov                 edx, dword ptr [ebp - 0xa4]
            //   0f438d4cffffff       | cmovae              ecx, dword ptr [ebp - 0xb4]
            //   6a04                 | push                4
            //   68????????           |                     

        $sequence_7 = { 84c0 7555 6a25 b9???????? }
            // n = 4, score = 200
            //   84c0                 | test                al, al
            //   7555                 | jne                 0x57
            //   6a25                 | push                0x25
            //   b9????????           |                     

        $sequence_8 = { c74584ffffffff 6a64 8d4588 50 ff15???????? 8d7d88 }
            // n = 6, score = 200
            //   c74584ffffffff       | mov                 dword ptr [ebp - 0x7c], 0xffffffff
            //   6a64                 | push                0x64
            //   8d4588               | lea                 eax, [ebp - 0x78]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8d7d88               | lea                 edi, [ebp - 0x78]

        $sequence_9 = { 6a00 ff15???????? 8d8df8f8ffff e8???????? 83781410 7202 8b00 }
            // n = 7, score = 200
            //   6a00                 | push                0
            //   ff15????????         |                     
            //   8d8df8f8ffff         | lea                 ecx, [ebp - 0x708]
            //   e8????????           |                     
            //   83781410             | cmp                 dword ptr [eax + 0x14], 0x10
            //   7202                 | jb                  4
            //   8b00                 | mov                 eax, dword ptr [eax]

    condition:
        7 of them and filesize < 1007616
}