rule win_microbackdoor_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.microbackdoor."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.microbackdoor"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 56 6a00 68e9fd0000 ff15???????? 33c0 50 50 }
            // n = 7, score = 100
            //   56                   | dec                 eax
            //   6a00                 | mov                 ebx, dword ptr [esp + 0x30]
            //   68e9fd0000           | mov                 eax, 1
            //   ff15????????         |                     
            //   33c0                 | dec                 eax
            //   50                   | mov                 ebp, dword ptr [esp + 0x38]
            //   50                   | pop                 ecx

        $sequence_1 = { 4863c8 4803d9 443823 75b3 418bf5 e9???????? 418bc7 }
            // n = 7, score = 100
            //   4863c8               | mov                 ecx, ebx
            //   4803d9               | inc                 ebp
            //   443823               | mov                 esp, edi
            //   75b3                 | inc                 ecx
            //   418bf5               | mov                 esi, ebp
            //   e9????????           |                     
            //   418bc7               | dec                 eax

        $sequence_2 = { 448d6f01 b940000000 418bd5 ff15???????? 488bd8 4885c0 0f8441010000 }
            // n = 7, score = 100
            //   448d6f01             | cmp                 byte ptr [ecx + eax], cl
            //   b940000000           | jne                 0xa
            //   418bd5               | inc                 eax
            //   ff15????????         |                     
            //   488bd8               | dec                 eax
            //   4885c0               | arpl                ax, cx
            //   0f8441010000         | dec                 eax

        $sequence_3 = { 8d4801 83f901 7620 03d8 3bdf 7cda b801000000 }
            // n = 7, score = 100
            //   8d4801               | mov                 edi, eax
            //   83f901               | inc                 ecx
            //   7620                 | movzx               esi, ax
            //   03d8                 | inc                 esp
            //   3bdf                 | mov                 esi, edx
            //   7cda                 | dec                 eax
            //   b801000000           | mov                 ebx, ecx

        $sequence_4 = { 0f849a000000 48899c24b0040000 4889bc2488040000 4c89bc2480040000 e8???????? 8bf8 e8???????? }
            // n = 7, score = 100
            //   0f849a000000         | jmp                 0xffffffca
            //   48899c24b0040000     | je                  0xa0
            //   4889bc2488040000     | dec                 eax
            //   4c89bc2480040000     | mov                 dword ptr [esp + 0x4b0], ebx
            //   e8????????           |                     
            //   8bf8                 | dec                 eax
            //   e8????????           |                     

        $sequence_5 = { 59 59 85c0 74eb 56 }
            // n = 5, score = 100
            //   59                   | mov                 ecx, eax
            //   59                   | and                 ecx, 0x7fffffff
            //   85c0                 | cmp                 ecx, 2
            //   74eb                 | je                  0x2b
            //   56                   | mov                 eax, dword ptr [ebp - 4]

        $sequence_6 = { ff15???????? 85c0 7507 ffd7 e9???????? 8d8570feffff 50 }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   85c0                 | xor                 edx, edx
            //   7507                 | mov                 ax, word ptr [ecx + 2]
            //   ffd7                 | lea                 ecx, [ecx + 2]
            //   e9????????           |                     
            //   8d8570feffff         | push                esi
            //   50                   | push                0

        $sequence_7 = { e8???????? 59 8bc8 81e1ffffff7f 83f902 741e }
            // n = 6, score = 100
            //   e8????????           |                     
            //   59                   | inc                 ecx
            //   8bc8                 | mov                 eax, edi
            //   81e1ffffff7f         | jne                 0x18
            //   83f902               | dec                 eax
            //   741e                 | lea                 ecx, [0x2509]

        $sequence_8 = { eb25 488bcb 458be7 418bf5 }
            // n = 4, score = 100
            //   eb25                 | lea                 ecx, [eax + 1]
            //   488bcb               | cmp                 ecx, 1
            //   458be7               | jbe                 0x22
            //   418bf5               | add                 ebx, eax

        $sequence_9 = { 410fb7f0 448bf2 488bd9 e8???????? }
            // n = 4, score = 100
            //   410fb7f0             | mov                 dword ptr [esp + 0x488], edi
            //   448bf2               | dec                 esp
            //   488bd9               | mov                 dword ptr [esp + 0x480], edi
            //   e8????????           |                     

        $sequence_10 = { 7507 33c0 66894473fe 8d4bfe 33d2 668b4102 8d4902 }
            // n = 7, score = 100
            //   7507                 | mov                 ebx, eax
            //   33c0                 | dec                 eax
            //   66894473fe           | test                eax, eax
            //   8d4bfe               | je                  0x155
            //   33d2                 | mov                 word ptr [ebx + edi + 0x34], si
            //   668b4102             | mov                 dword ptr [ebx + edi + 0x38], 2
            //   8d4902               | inc                 dword ptr [edi]

        $sequence_11 = { 8b45f0 8945e0 8d45dc 6a08 }
            // n = 4, score = 100
            //   8b45f0               | push                1
            //   8945e0               | pop                 ecx
            //   8d45dc               | cmove               eax, ecx
            //   6a08                 | pop                 edi

        $sequence_12 = { a3???????? 85c0 740d ffd7 3db7000000 0f8446010000 56 }
            // n = 7, score = 100
            //   a3????????           |                     
            //   85c0                 | pop                 esi
            //   740d                 | pop                 ebx
            //   ffd7                 | jne                 9
            //   3db7000000           | xor                 eax, eax
            //   0f8446010000         | mov                 word ptr [ebx + esi*2 - 2], ax
            //   56                   | lea                 ecx, [ebx - 2]

        $sequence_13 = { 8b45fc 6a01 59 0f44c1 5f 5e 5b }
            // n = 7, score = 100
            //   8b45fc               | mov                 edx, eax
            //   6a01                 | inc                 esp
            //   59                   | lea                 ebp, [edi + 1]
            //   0f44c1               | mov                 ecx, 0x40
            //   5f                   | inc                 ecx
            //   5e                   | mov                 edx, ebp
            //   5b                   | dec                 eax

        $sequence_14 = { 4885d2 7410 46380c01 7502 ffc0 }
            // n = 5, score = 100
            //   4885d2               | cmp                 ebx, edi
            //   7410                 | jl                  0xffffffe2
            //   46380c01             | mov                 eax, 1
            //   7502                 | jmp                 0x27
            //   ffc0                 | dec                 eax

        $sequence_15 = { ebe0 ff15???????? 488d0de93e0000 8bd0 e8???????? ebc8 }
            // n = 6, score = 100
            //   ebe0                 | jmp                 0xffffffe2
            //   ff15????????         |                     
            //   488d0de93e0000       | dec                 eax
            //   8bd0                 | lea                 ecx, [0x3ee9]
            //   e8????????           |                     
            //   ebc8                 | mov                 edx, eax

    condition:
        7 of them and filesize < 123904
}