rule win_milum_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.milum."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.milum"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 56 8d5db4 53 8b5dac 53 8b5da0 50 }
            // n = 7, score = 400
            //   56                   | push                esi
            //   8d5db4               | lea                 ebx, [ebp - 0x4c]
            //   53                   | push                ebx
            //   8b5dac               | mov                 ebx, dword ptr [ebp - 0x54]
            //   53                   | push                ebx
            //   8b5da0               | mov                 ebx, dword ptr [ebp - 0x60]
            //   50                   | push                eax

        $sequence_1 = { 8b4608 8d80349e4700 fe08 803800 7f1c 8bce e8???????? }
            // n = 7, score = 400
            //   8b4608               | mov                 eax, dword ptr [esi + 8]
            //   8d80349e4700         | lea                 eax, [eax + 0x479e34]
            //   fe08                 | dec                 byte ptr [eax]
            //   803800               | cmp                 byte ptr [eax], 0
            //   7f1c                 | jg                  0x1e
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     

        $sequence_2 = { c6460165 e8???????? 5f 8be5 5d c3 8d4bff }
            // n = 7, score = 400
            //   c6460165             | mov                 byte ptr [esi + 1], 0x65
            //   e8????????           |                     
            //   5f                   | pop                 edi
            //   8be5                 | mov                 esp, ebp
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   8d4bff               | lea                 ecx, [ebx - 1]

        $sequence_3 = { c745fc01000000 8d7b0f 395dac 7524 6a10 68???????? 8d4db8 }
            // n = 7, score = 400
            //   c745fc01000000       | mov                 dword ptr [ebp - 4], 1
            //   8d7b0f               | lea                 edi, [ebx + 0xf]
            //   395dac               | cmp                 dword ptr [ebp - 0x54], ebx
            //   7524                 | jne                 0x26
            //   6a10                 | push                0x10
            //   68????????           |                     
            //   8d4db8               | lea                 ecx, [ebp - 0x48]

        $sequence_4 = { 8d45f4 64a300000000 8965f0 8b7d08 33f6 8975ec 897708 }
            // n = 7, score = 400
            //   8d45f4               | lea                 eax, [ebp - 0xc]
            //   64a300000000         | mov                 dword ptr fs:[0], eax
            //   8965f0               | mov                 dword ptr [ebp - 0x10], esp
            //   8b7d08               | mov                 edi, dword ptr [ebp + 8]
            //   33f6                 | xor                 esi, esi
            //   8975ec               | mov                 dword ptr [ebp - 0x14], esi
            //   897708               | mov                 dword ptr [edi + 8], esi

        $sequence_5 = { 7506 8b4b08 894b10 8b16 837a1000 0f8560fdffff }
            // n = 6, score = 400
            //   7506                 | jne                 8
            //   8b4b08               | mov                 ecx, dword ptr [ebx + 8]
            //   894b10               | mov                 dword ptr [ebx + 0x10], ecx
            //   8b16                 | mov                 edx, dword ptr [esi]
            //   837a1000             | cmp                 dword ptr [edx + 0x10], 0
            //   0f8560fdffff         | jne                 0xfffffd66

        $sequence_6 = { 8bcc 8965bc 6aff 53 8d45d4 897114 895910 }
            // n = 7, score = 400
            //   8bcc                 | mov                 ecx, esp
            //   8965bc               | mov                 dword ptr [ebp - 0x44], esp
            //   6aff                 | push                -1
            //   53                   | push                ebx
            //   8d45d4               | lea                 eax, [ebp - 0x2c]
            //   897114               | mov                 dword ptr [ecx + 0x14], esi
            //   895910               | mov                 dword ptr [ecx + 0x10], ebx

        $sequence_7 = { 7456 50 53 8d4dd0 e8???????? eb3d 8b35???????? }
            // n = 7, score = 400
            //   7456                 | je                  0x58
            //   50                   | push                eax
            //   53                   | push                ebx
            //   8d4dd0               | lea                 ecx, [ebp - 0x30]
            //   e8????????           |                     
            //   eb3d                 | jmp                 0x3f
            //   8b35????????         |                     

        $sequence_8 = { c645fc02 83c204 8955d0 8b4304 3bf8 736d 8b13 }
            // n = 7, score = 400
            //   c645fc02             | mov                 byte ptr [ebp - 4], 2
            //   83c204               | add                 edx, 4
            //   8955d0               | mov                 dword ptr [ebp - 0x30], edx
            //   8b4304               | mov                 eax, dword ptr [ebx + 4]
            //   3bf8                 | cmp                 edi, eax
            //   736d                 | jae                 0x6f
            //   8b13                 | mov                 edx, dword ptr [ebx]

        $sequence_9 = { 7446 83ec1c 8bfc 89a5ecfdffff 83ec1c 8bcc 89a5e8fdffff }
            // n = 7, score = 400
            //   7446                 | je                  0x48
            //   83ec1c               | sub                 esp, 0x1c
            //   8bfc                 | mov                 edi, esp
            //   89a5ecfdffff         | mov                 dword ptr [ebp - 0x214], esp
            //   83ec1c               | sub                 esp, 0x1c
            //   8bcc                 | mov                 ecx, esp
            //   89a5e8fdffff         | mov                 dword ptr [ebp - 0x218], esp

    condition:
        7 of them and filesize < 1076224
}