rule win_mindware_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.mindware."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.mindware"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 85c0 750a 6a64 ff15???????? ebe3 8be5 }
            // n = 6, score = 100
            //   85c0                 | test                eax, eax
            //   750a                 | jne                 0xc
            //   6a64                 | push                0x64
            //   ff15????????         |                     
            //   ebe3                 | jmp                 0xffffffe5
            //   8be5                 | mov                 esp, ebp

        $sequence_1 = { 33d1 8b4dec c1e908 0fb6c9 c1e208 0fb689c0b74400 }
            // n = 6, score = 100
            //   33d1                 | xor                 edx, ecx
            //   8b4dec               | mov                 ecx, dword ptr [ebp - 0x14]
            //   c1e908               | shr                 ecx, 8
            //   0fb6c9               | movzx               ecx, cl
            //   c1e208               | shl                 edx, 8
            //   0fb689c0b74400       | movzx               ecx, byte ptr [ecx + 0x44b7c0]

        $sequence_2 = { c78594f2ffff44e44300 c78598f2ffff4ce44300 c7859cf2ffff54e44300 c785a0f2ffff64e44300 }
            // n = 4, score = 100
            //   c78594f2ffff44e44300     | mov    dword ptr [ebp - 0xd6c], 0x43e444
            //   c78598f2ffff4ce44300     | mov    dword ptr [ebp - 0xd68], 0x43e44c
            //   c7859cf2ffff54e44300     | mov    dword ptr [ebp - 0xd64], 0x43e454
            //   c785a0f2ffff64e44300     | mov    dword ptr [ebp - 0xd60], 0x43e464

        $sequence_3 = { c78578ffffff00001000 c7857cffffff00000000 eb12 8b55d0 899578ffffff 8b45d4 89857cffffff }
            // n = 7, score = 100
            //   c78578ffffff00001000     | mov    dword ptr [ebp - 0x88], 0x100000
            //   c7857cffffff00000000     | mov    dword ptr [ebp - 0x84], 0
            //   eb12                 | jmp                 0x14
            //   8b55d0               | mov                 edx, dword ptr [ebp - 0x30]
            //   899578ffffff         | mov                 dword ptr [ebp - 0x88], edx
            //   8b45d4               | mov                 eax, dword ptr [ebp - 0x2c]
            //   89857cffffff         | mov                 dword ptr [ebp - 0x84], eax

        $sequence_4 = { c78550f4ffffb4e84300 c78554f4ffffbce84300 c78558f4ffffc4e84300 c7855cf4ffffcce84300 c78560f4ffffd4e84300 c78564f4ffffdce84300 c78568f4ffffe4e84300 }
            // n = 7, score = 100
            //   c78550f4ffffb4e84300     | mov    dword ptr [ebp - 0xbb0], 0x43e8b4
            //   c78554f4ffffbce84300     | mov    dword ptr [ebp - 0xbac], 0x43e8bc
            //   c78558f4ffffc4e84300     | mov    dword ptr [ebp - 0xba8], 0x43e8c4
            //   c7855cf4ffffcce84300     | mov    dword ptr [ebp - 0xba4], 0x43e8cc
            //   c78560f4ffffd4e84300     | mov    dword ptr [ebp - 0xba0], 0x43e8d4
            //   c78564f4ffffdce84300     | mov    dword ptr [ebp - 0xb9c], 0x43e8dc
            //   c78568f4ffffe4e84300     | mov    dword ptr [ebp - 0xb98], 0x43e8e4

        $sequence_5 = { 8955d4 8955d8 8b4508 83c02c 50 ff15???????? }
            // n = 6, score = 100
            //   8955d4               | mov                 dword ptr [ebp - 0x2c], edx
            //   8955d8               | mov                 dword ptr [ebp - 0x28], edx
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   83c02c               | add                 eax, 0x2c
            //   50                   | push                eax
            //   ff15????????         |                     

        $sequence_6 = { c1e104 034c2414 8b01 8907 8b4104 }
            // n = 5, score = 100
            //   c1e104               | shl                 ecx, 4
            //   034c2414             | add                 ecx, dword ptr [esp + 0x14]
            //   8b01                 | mov                 eax, dword ptr [ecx]
            //   8907                 | mov                 dword ptr [edi], eax
            //   8b4104               | mov                 eax, dword ptr [ecx + 4]

        $sequence_7 = { 895824 0fb689f0d84400 894d10 0fb6ca 0fb689f0d84400 c1e108 314d10 }
            // n = 7, score = 100
            //   895824               | mov                 dword ptr [eax + 0x24], ebx
            //   0fb689f0d84400       | movzx               ecx, byte ptr [ecx + 0x44d8f0]
            //   894d10               | mov                 dword ptr [ebp + 0x10], ecx
            //   0fb6ca               | movzx               ecx, dl
            //   0fb689f0d84400       | movzx               ecx, byte ptr [ecx + 0x44d8f0]
            //   c1e108               | shl                 ecx, 8
            //   314d10               | xor                 dword ptr [ebp + 0x10], ecx

        $sequence_8 = { 8bf2 03f9 c1ce0d 03b8e83f4400 03bc05ccfeffff 037df4 }
            // n = 6, score = 100
            //   8bf2                 | mov                 esi, edx
            //   03f9                 | add                 edi, ecx
            //   c1ce0d               | ror                 esi, 0xd
            //   03b8e83f4400         | add                 edi, dword ptr [eax + 0x443fe8]
            //   03bc05ccfeffff       | add                 edi, dword ptr [ebp + eax - 0x134]
            //   037df4               | add                 edi, dword ptr [ebp - 0xc]

        $sequence_9 = { 8945fc c745f001000000 837dfc00 7541 c745ec00000000 c745f800000000 8b4d08 }
            // n = 7, score = 100
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   c745f001000000       | mov                 dword ptr [ebp - 0x10], 1
            //   837dfc00             | cmp                 dword ptr [ebp - 4], 0
            //   7541                 | jne                 0x43
            //   c745ec00000000       | mov                 dword ptr [ebp - 0x14], 0
            //   c745f800000000       | mov                 dword ptr [ebp - 8], 0
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]

    condition:
        7 of them and filesize < 661504
}