rule win_minibike_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.minibike."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.minibike"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b7ffc 83c123 2bc7 83c0fc 83f81f 0f8741040000 }
            // n = 6, score = 100
            //   8b7ffc               | mov                 edi, dword ptr [edi - 4]
            //   83c123               | add                 ecx, 0x23
            //   2bc7                 | sub                 eax, edi
            //   83c0fc               | add                 eax, -4
            //   83f81f               | cmp                 eax, 0x1f
            //   0f8741040000         | ja                  0x447

        $sequence_1 = { e8???????? 83c408 0f2805???????? 33c9 0f1145b8 c745c8201b233e 66c745cc2700 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   0f2805????????       |                     
            //   33c9                 | xor                 ecx, ecx
            //   0f1145b8             | movups              xmmword ptr [ebp - 0x48], xmm0
            //   c745c8201b233e       | mov                 dword ptr [ebp - 0x38], 0x3e231b20
            //   66c745cc2700         | mov                 word ptr [ebp - 0x34], 0x27

        $sequence_2 = { 0f57c0 50 660fd685b0feffff 0f2805???????? 51 8d8db0feffff 0f1185d0fcffff }
            // n = 7, score = 100
            //   0f57c0               | xorps               xmm0, xmm0
            //   50                   | push                eax
            //   660fd685b0feffff     | movq                qword ptr [ebp - 0x150], xmm0
            //   0f2805????????       |                     
            //   51                   | push                ecx
            //   8d8db0feffff         | lea                 ecx, [ebp - 0x150]
            //   0f1185d0fcffff       | movups              xmmword ptr [ebp - 0x330], xmm0

        $sequence_3 = { 8b4df4 b867666666 8b1b 83c404 8b4908 2bcb }
            // n = 6, score = 100
            //   8b4df4               | mov                 ecx, dword ptr [ebp - 0xc]
            //   b867666666           | mov                 eax, 0x66666667
            //   8b1b                 | mov                 ebx, dword ptr [ebx]
            //   83c404               | add                 esp, 4
            //   8b4908               | mov                 ecx, dword ptr [ecx + 8]
            //   2bcb                 | sub                 ecx, ebx

        $sequence_4 = { 898df4fcffff 89b5f0fcffff 8985f8fcffff 85c0 7445 8bb5a4fdffff 8b95f0fcffff }
            // n = 7, score = 100
            //   898df4fcffff         | mov                 dword ptr [ebp - 0x30c], ecx
            //   89b5f0fcffff         | mov                 dword ptr [ebp - 0x310], esi
            //   8985f8fcffff         | mov                 dword ptr [ebp - 0x308], eax
            //   85c0                 | test                eax, eax
            //   7445                 | je                  0x47
            //   8bb5a4fdffff         | mov                 esi, dword ptr [ebp - 0x25c]
            //   8b95f0fcffff         | mov                 edx, dword ptr [ebp - 0x310]

        $sequence_5 = { c745d400000000 8d45c0 660fd645cc 0f2805???????? 50 51 8d4dcc }
            // n = 7, score = 100
            //   c745d400000000       | mov                 dword ptr [ebp - 0x2c], 0
            //   8d45c0               | lea                 eax, [ebp - 0x40]
            //   660fd645cc           | movq                qword ptr [ebp - 0x34], xmm0
            //   0f2805????????       |                     
            //   50                   | push                eax
            //   51                   | push                ecx
            //   8d4dcc               | lea                 ecx, [ebp - 0x34]

        $sequence_6 = { 8d8588fdffff 660fd685e4fdffff 0f2805???????? 50 51 8d8de4fdffff c78584fdffff05000000 }
            // n = 7, score = 100
            //   8d8588fdffff         | lea                 eax, [ebp - 0x278]
            //   660fd685e4fdffff     | movq                qword ptr [ebp - 0x21c], xmm0
            //   0f2805????????       |                     
            //   50                   | push                eax
            //   51                   | push                ecx
            //   8d8de4fdffff         | lea                 ecx, [ebp - 0x21c]
            //   c78584fdffff05000000     | mov    dword ptr [ebp - 0x27c], 5

        $sequence_7 = { 743a 8b85d8fdffff 2bc7 c1f802 8d0c8500000000 8bc7 81f900100000 }
            // n = 7, score = 100
            //   743a                 | je                  0x3c
            //   8b85d8fdffff         | mov                 eax, dword ptr [ebp - 0x228]
            //   2bc7                 | sub                 eax, edi
            //   c1f802               | sar                 eax, 2
            //   8d0c8500000000       | lea                 ecx, [eax*4]
            //   8bc7                 | mov                 eax, edi
            //   81f900100000         | cmp                 ecx, 0x1000

        $sequence_8 = { 33c9 c745b00b0c0716 c745b44c060e0e c645b800 90 8d45ad 301408 }
            // n = 7, score = 100
            //   33c9                 | xor                 ecx, ecx
            //   c745b00b0c0716       | mov                 dword ptr [ebp - 0x50], 0x16070c0b
            //   c745b44c060e0e       | mov                 dword ptr [ebp - 0x4c], 0xe0e064c
            //   c645b800             | mov                 byte ptr [ebp - 0x48], 0
            //   90                   | nop                 
            //   8d45ad               | lea                 eax, [ebp - 0x53]
            //   301408               | xor                 byte ptr [eax + ecx], dl

        $sequence_9 = { e8???????? 8bce e8???????? 8bf0 e9???????? 6a02 33c0 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     
            //   8bf0                 | mov                 esi, eax
            //   e9????????           |                     
            //   6a02                 | push                2
            //   33c0                 | xor                 eax, eax

    condition:
        7 of them and filesize < 574464
}