rule win_mokes_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.mokes."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.mokes"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff7204 8b5004 51 8bce e8???????? c644244c04 83c40c }
            // n = 7, score = 400
            //   ff7204               | push                dword ptr [edx + 4]
            //   8b5004               | mov                 edx, dword ptr [eax + 4]
            //   51                   | push                ecx
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     
            //   c644244c04           | mov                 byte ptr [esp + 0x4c], 4
            //   83c40c               | add                 esp, 0xc

        $sequence_1 = { ff37 8b4d58 e8???????? ff33 8b4d5c e8???????? 8b4d24 }
            // n = 7, score = 400
            //   ff37                 | push                dword ptr [edi]
            //   8b4d58               | mov                 ecx, dword ptr [ebp + 0x58]
            //   e8????????           |                     
            //   ff33                 | push                dword ptr [ebx]
            //   8b4d5c               | mov                 ecx, dword ptr [ebp + 0x5c]
            //   e8????????           |                     
            //   8b4d24               | mov                 ecx, dword ptr [ebp + 0x24]

        $sequence_2 = { f30fe6c0 f20f59cb f20f584850 f20f5cc8 f20f104660 f20f59c3 f20f584650 }
            // n = 7, score = 400
            //   f30fe6c0             | cvtdq2pd            xmm0, xmm0
            //   f20f59cb             | mulsd               xmm1, xmm3
            //   f20f584850           | addsd               xmm1, qword ptr [eax + 0x50]
            //   f20f5cc8             | subsd               xmm1, xmm0
            //   f20f104660           | movsd               xmm0, qword ptr [esi + 0x60]
            //   f20f59c3             | mulsd               xmm0, xmm3
            //   f20f584650           | addsd               xmm0, qword ptr [esi + 0x50]

        $sequence_3 = { f00fc101 ff742414 8d44242c 8bce 50 e8???????? 8d4c2428 }
            // n = 7, score = 400
            //   f00fc101             | lock xadd           dword ptr [ecx], eax
            //   ff742414             | push                dword ptr [esp + 0x14]
            //   8d44242c             | lea                 eax, [esp + 0x2c]
            //   8bce                 | mov                 ecx, esi
            //   50                   | push                eax
            //   e8????????           |                     
            //   8d4c2428             | lea                 ecx, [esp + 0x28]

        $sequence_4 = { ff15???????? 85c0 7435 8d942494000000 8d4c2454 e8???????? c68424a802000004 }
            // n = 7, score = 400
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7435                 | je                  0x37
            //   8d942494000000       | lea                 edx, [esp + 0x94]
            //   8d4c2454             | lea                 ecx, [esp + 0x54]
            //   e8????????           |                     
            //   c68424a802000004     | mov                 byte ptr [esp + 0x2a8], 4

        $sequence_5 = { f6c444 7a10 f20f1025???????? f20f11642408 eb48 f20f5905???????? f20f11442408 }
            // n = 7, score = 400
            //   f6c444               | test                ah, 0x44
            //   7a10                 | jp                  0x12
            //   f20f1025????????     |                     
            //   f20f11642408         | movsd               qword ptr [esp + 8], xmm4
            //   eb48                 | jmp                 0x4a
            //   f20f5905????????     |                     
            //   f20f11442408         | movsd               qword ptr [esp + 8], xmm0

        $sequence_6 = { f6c202 743b 8b442440 83e2fd 89542428 8b08 85c9 }
            // n = 7, score = 400
            //   f6c202               | test                dl, 2
            //   743b                 | je                  0x3d
            //   8b442440             | mov                 eax, dword ptr [esp + 0x40]
            //   83e2fd               | and                 edx, 0xfffffffd
            //   89542428             | mov                 dword ptr [esp + 0x28], edx
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   85c9                 | test                ecx, ecx

        $sequence_7 = { ff5014 5f 5e 8be5 5d c3 ff500c }
            // n = 7, score = 400
            //   ff5014               | call                dword ptr [eax + 0x14]
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   8be5                 | mov                 esp, ebp
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   ff500c               | call                dword ptr [eax + 0xc]

        $sequence_8 = { ff7610 8d8f9c000000 e8???????? 85c0 7413 8bc8 c1e104 }
            // n = 7, score = 400
            //   ff7610               | push                dword ptr [esi + 0x10]
            //   8d8f9c000000         | lea                 ecx, [edi + 0x9c]
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   7413                 | je                  0x15
            //   8bc8                 | mov                 ecx, eax
            //   c1e104               | shl                 ecx, 4

        $sequence_9 = { ff5274 85c0 741b 807c241800 b820000000 b910000000 0f45c1 }
            // n = 7, score = 400
            //   ff5274               | call                dword ptr [edx + 0x74]
            //   85c0                 | test                eax, eax
            //   741b                 | je                  0x1d
            //   807c241800           | cmp                 byte ptr [esp + 0x18], 0
            //   b820000000           | mov                 eax, 0x20
            //   b910000000           | mov                 ecx, 0x10
            //   0f45c1               | cmovne              eax, ecx

    condition:
        7 of them and filesize < 18505728
}