rule win_moriya_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.moriya."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.moriya"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 418067bb0f 8a4618 240f 410847bb }
            // n = 4, score = 100
            //   418067bb0f           | mov                 eax, 0x118
            //   8a4618               | movups              xmmword ptr [esp + 0x30], xmm0
            //   240f                 | xor                 edx, edx
            //   410847bb             | dec                 ecx

        $sequence_1 = { 83c204 e8???????? 8b4708 48894338 33d2 }
            // n = 5, score = 100
            //   83c204               | mov                 eax, esp
            //   e8????????           |                     
            //   8b4708               | inc                 esp
            //   48894338             | mov                 dword ptr [esp + 0x34], esp
            //   33d2                 | inc                 ecx

        $sequence_2 = { 488b0d???????? 4533c9 f30f7f45a0 4889442470 4533c0 0f1007 }
            // n = 6, score = 100
            //   488b0d????????       |                     
            //   4533c9               | dec                 eax
            //   f30f7f45a0           | dec                 ecx
            //   4889442470           | dec                 ecx
            //   4533c0               | dec                 eax
            //   0f1007               | mov                 byte ptr [ecx], al

        $sequence_3 = { 7443 0f57c0 33c0 0f1107 }
            // n = 4, score = 100
            //   7443                 | dec                 eax
            //   0f57c0               | lea                 edx, [eax*4]
            //   33c0                 | dec                 ecx
            //   0f1107               | add                 edx, ebp

        $sequence_4 = { 488364246000 4c8d4c2460 488364246800 4c8d442468 ba01000000 488d4c2470 }
            // n = 6, score = 100
            //   488364246000         | mov                 ecx, eax
            //   4c8d4c2460           | dec                 esp
            //   488364246800         | sub                 eax, edx
            //   4c8d442468           | dec                 ecx
            //   ba01000000           | shr                 eax, 1
            //   488d4c2470           | dec                 esp

        $sequence_5 = { e8???????? 33d2 488905???????? 418bce 4885c0 7509 4c8d05b60f0000 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   33d2                 | mov                 eax, dword ptr [edi + 8]
            //   488905????????       |                     
            //   418bce               | mov                 edx, dword ptr [edi + 0x30]
            //   4885c0               | test                edx, edx
            //   7509                 | js                  0x12e5
            //   4c8d05b60f0000       | test                byte ptr [esi + 0x18], 0x40

        $sequence_6 = { 4983e007 7417 660f1f840000000000 8a4411ff }
            // n = 4, score = 100
            //   4983e007             | dec                 eax
            //   7417                 | mov                 dword ptr [esi + 0x10], eax
            //   660f1f840000000000     | mov    al, byte ptr [ebx + 3]
            //   8a4411ff             | mov                 byte ptr [esi + 0x18], al

        $sequence_7 = { 488bc8 e8???????? 4c8b4730 4c8d4c2420 488b15???????? 488bcf }
            // n = 6, score = 100
            //   488bc8               | xor                 ecx, esp
            //   e8????????           |                     
            //   4c8b4730             | je                  0x15f6
            //   4c8d4c2420           | test                byte ptr [esi + 0x18], 0x20
            //   488b15????????       |                     
            //   488bcf               | jne                 0x160c

        $sequence_8 = { 498bc9 e8???????? 418bc4 4869c838010000 4903cd }
            // n = 5, score = 100
            //   498bc9               | dec                 eax
            //   e8????????           |                     
            //   418bc4               | test                eax, eax
            //   4869c838010000       | xor                 ecx, ecx
            //   4903cd               | dec                 eax

        $sequence_9 = { 7831 488b0d???????? 488b81e0000000 488905???????? }
            // n = 4, score = 100
            //   7831                 | dec                 ebp
            //   488b0d????????       |                     
            //   488b81e0000000       | add                 ecx, ebp
            //   488905????????       |                     

    condition:
        7 of them and filesize < 58368
}