rule win_morto_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.morto."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.morto"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 6a03 53 6a03 8d8594fdffff 57 50 ff15???????? }
            // n = 7, score = 200
            //   6a03                 | push                3
            //   53                   | push                ebx
            //   6a03                 | push                3
            //   8d8594fdffff         | lea                 eax, [ebp - 0x26c]
            //   57                   | push                edi
            //   50                   | push                eax
            //   ff15????????         |                     

        $sequence_1 = { 84c9 7412 8a5601 8aca 3a5701 750c }
            // n = 6, score = 200
            //   84c9                 | test                cl, cl
            //   7412                 | je                  0x14
            //   8a5601               | mov                 dl, byte ptr [esi + 1]
            //   8aca                 | mov                 cl, dl
            //   3a5701               | cmp                 dl, byte ptr [edi + 1]
            //   750c                 | jne                 0xe

        $sequence_2 = { 85c0 7543 8a45ff be???????? fec0 8bce 50 }
            // n = 7, score = 200
            //   85c0                 | test                eax, eax
            //   7543                 | jne                 0x45
            //   8a45ff               | mov                 al, byte ptr [ebp - 1]
            //   be????????           |                     
            //   fec0                 | inc                 al
            //   8bce                 | mov                 ecx, esi
            //   50                   | push                eax

        $sequence_3 = { 53 50 56 89750c }
            // n = 4, score = 200
            //   53                   | push                ebx
            //   50                   | push                eax
            //   56                   | push                esi
            //   89750c               | mov                 dword ptr [ebp + 0xc], esi

        $sequence_4 = { a3???????? e8???????? 6a01 68???????? ff35???????? a3???????? }
            // n = 6, score = 200
            //   a3????????           |                     
            //   e8????????           |                     
            //   6a01                 | push                1
            //   68????????           |                     
            //   ff35????????         |                     
            //   a3????????           |                     

        $sequence_5 = { ebb6 8b02 0345fc eb02 }
            // n = 4, score = 200
            //   ebb6                 | jmp                 0xffffffb8
            //   8b02                 | mov                 eax, dword ptr [edx]
            //   0345fc               | add                 eax, dword ptr [ebp - 4]
            //   eb02                 | jmp                 4

        $sequence_6 = { 50 e8???????? 83c40c 8945e4 8d45cc }
            // n = 5, score = 200
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   8945e4               | mov                 dword ptr [ebp - 0x1c], eax
            //   8d45cc               | lea                 eax, [ebp - 0x34]

        $sequence_7 = { 55 8bec 81ec10020000 53 8b5d08 8365f800 56 }
            // n = 7, score = 200
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   81ec10020000         | sub                 esp, 0x210
            //   53                   | push                ebx
            //   8b5d08               | mov                 ebx, dword ptr [ebp + 8]
            //   8365f800             | and                 dword ptr [ebp - 8], 0
            //   56                   | push                esi

        $sequence_8 = { 7533 8d8594fdffff 56 50 8d4594 50 }
            // n = 6, score = 200
            //   7533                 | jne                 0x35
            //   8d8594fdffff         | lea                 eax, [ebp - 0x26c]
            //   56                   | push                esi
            //   50                   | push                eax
            //   8d4594               | lea                 eax, [ebp - 0x6c]
            //   50                   | push                eax

        $sequence_9 = { eb0a 33d2 8a1419 41 8d441201 8bd0 c1ea08 }
            // n = 7, score = 200
            //   eb0a                 | jmp                 0xc
            //   33d2                 | xor                 edx, edx
            //   8a1419               | mov                 dl, byte ptr [ecx + ebx]
            //   41                   | inc                 ecx
            //   8d441201             | lea                 eax, [edx + edx + 1]
            //   8bd0                 | mov                 edx, eax
            //   c1ea08               | shr                 edx, 8

    condition:
        7 of them and filesize < 49152
}