rule win_ncctrojan_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.ncctrojan."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.ncctrojan"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83f805 7536 8b85e8feffff 85c0 750a }
            // n = 5, score = 500
            //   83f805               | cmp                 eax, 5
            //   7536                 | jne                 0x38
            //   8b85e8feffff         | mov                 eax, dword ptr [ebp - 0x118]
            //   85c0                 | test                eax, eax
            //   750a                 | jne                 0xc

        $sequence_1 = { 68???????? e9???????? 83f801 750a }
            // n = 4, score = 500
            //   68????????           |                     
            //   e9????????           |                     
            //   83f801               | cmp                 eax, 1
            //   750a                 | jne                 0xc

        $sequence_2 = { 750a 68???????? e9???????? 83f802 }
            // n = 4, score = 500
            //   750a                 | jne                 0xc
            //   68????????           |                     
            //   e9????????           |                     
            //   83f802               | cmp                 eax, 2

        $sequence_3 = { e9???????? 83f802 0f85bb000000 68???????? e9???????? 83f806 }
            // n = 6, score = 400
            //   e9????????           |                     
            //   83f802               | cmp                 eax, 2
            //   0f85bb000000         | jne                 0xc1
            //   68????????           |                     
            //   e9????????           |                     
            //   83f806               | cmp                 eax, 6

        $sequence_4 = { 8d44247c 6800400000 50 e8???????? 83c40c }
            // n = 5, score = 400
            //   8d44247c             | lea                 eax, [esp + 0x7c]
            //   6800400000           | push                0x4000
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc

        $sequence_5 = { ff15???????? 83f8ff 0f85e0000000 ff35???????? ff15???????? }
            // n = 5, score = 400
            //   ff15????????         |                     
            //   83f8ff               | cmp                 eax, -1
            //   0f85e0000000         | jne                 0xe6
            //   ff35????????         |                     
            //   ff15????????         |                     

        $sequence_6 = { 8d442450 50 6a00 68e9fd0000 ffd7 8d842470050000 }
            // n = 6, score = 400
            //   8d442450             | lea                 eax, [esp + 0x50]
            //   50                   | push                eax
            //   6a00                 | push                0
            //   68e9fd0000           | push                0xfde9
            //   ffd7                 | call                edi
            //   8d842470050000       | lea                 eax, [esp + 0x570]

        $sequence_7 = { 50 e8???????? 83c414 8d442450 50 8d44247c }
            // n = 6, score = 400
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c414               | add                 esp, 0x14
            //   8d442450             | lea                 eax, [esp + 0x50]
            //   50                   | push                eax
            //   8d44247c             | lea                 eax, [esp + 0x7c]

        $sequence_8 = { 56 ff15???????? 8b8580fffeff 83781408 }
            // n = 4, score = 300
            //   56                   | push                esi
            //   ff15????????         |                     
            //   8b8580fffeff         | mov                 eax, dword ptr [ebp - 0x10080]
            //   83781408             | cmp                 dword ptr [eax + 0x14], 8

        $sequence_9 = { 50 e8???????? 8b4d08 e8???????? e9???????? 8b4d08 e8???????? }
            // n = 7, score = 300
            //   50                   | push                eax
            //   e8????????           |                     
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   e8????????           |                     
            //   e9????????           |                     
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   e8????????           |                     

        $sequence_10 = { 6804010000 8d85f0fbffff 50 56 }
            // n = 4, score = 300
            //   6804010000           | push                0x104
            //   8d85f0fbffff         | lea                 eax, [ebp - 0x410]
            //   50                   | push                eax
            //   56                   | push                esi

        $sequence_11 = { 8965f0 6a01 8945ec 40 6a00 }
            // n = 5, score = 300
            //   8965f0               | mov                 dword ptr [ebp - 0x10], esp
            //   6a01                 | push                1
            //   8945ec               | mov                 dword ptr [ebp - 0x14], eax
            //   40                   | inc                 eax
            //   6a00                 | push                0

        $sequence_12 = { 56 57 6a00 68e9fd0000 ff15???????? 57 8bf0 }
            // n = 7, score = 300
            //   56                   | push                esi
            //   57                   | push                edi
            //   6a00                 | push                0
            //   68e9fd0000           | push                0xfde9
            //   ff15????????         |                     
            //   57                   | push                edi
            //   8bf0                 | mov                 esi, eax

        $sequence_13 = { 50 e8???????? 83781408 7202 8b00 50 8d85f0fbffff }
            // n = 7, score = 300
            //   50                   | push                eax
            //   e8????????           |                     
            //   83781408             | cmp                 dword ptr [eax + 0x14], 8
            //   7202                 | jb                  4
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   50                   | push                eax
            //   8d85f0fbffff         | lea                 eax, [ebp - 0x410]

        $sequence_14 = { 56 57 6a00 ff750c ff15???????? 57 }
            // n = 6, score = 300
            //   56                   | push                esi
            //   57                   | push                edi
            //   6a00                 | push                0
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   ff15????????         |                     
            //   57                   | push                edi

        $sequence_15 = { 50 e8???????? 6aff 8d4601 c645fc03 50 8d8518ffffff }
            // n = 7, score = 300
            //   50                   | push                eax
            //   e8????????           |                     
            //   6aff                 | push                -1
            //   8d4601               | lea                 eax, [esi + 1]
            //   c645fc03             | mov                 byte ptr [ebp - 4], 3
            //   50                   | push                eax
            //   8d8518ffffff         | lea                 eax, [ebp - 0xe8]

    condition:
        7 of them and filesize < 1160192
}