rule win_neconyd_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.neconyd."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.neconyd"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 56 56 56 8945f4 56 }
            // n = 6, score = 100
            //   e8????????           |                     
            //   56                   | push                esi
            //   56                   | push                esi
            //   56                   | push                esi
            //   8945f4               | mov                 dword ptr [ebp - 0xc], eax
            //   56                   | push                esi

        $sequence_1 = { 85c0 7509 57 ff15???????? ebc6 6aff 57 }
            // n = 7, score = 100
            //   85c0                 | test                eax, eax
            //   7509                 | jne                 0xb
            //   57                   | push                edi
            //   ff15????????         |                     
            //   ebc6                 | jmp                 0xffffffc8
            //   6aff                 | push                -1
            //   57                   | push                edi

        $sequence_2 = { 8bd8 ffd7 2bc3 3bc6 7340 }
            // n = 5, score = 100
            //   8bd8                 | mov                 ebx, eax
            //   ffd7                 | call                edi
            //   2bc3                 | sub                 eax, ebx
            //   3bc6                 | cmp                 eax, esi
            //   7340                 | jae                 0x42

        $sequence_3 = { 8d4c2418 e8???????? 83f8ff 8944241c 0f84e6010000 6826060000 }
            // n = 6, score = 100
            //   8d4c2418             | lea                 ecx, [esp + 0x18]
            //   e8????????           |                     
            //   83f8ff               | cmp                 eax, -1
            //   8944241c             | mov                 dword ptr [esp + 0x1c], eax
            //   0f84e6010000         | je                  0x1ec
            //   6826060000           | push                0x626

        $sequence_4 = { ff75f8 03d0 837d6806 52 ffb49d2cffffff 7407 }
            // n = 6, score = 100
            //   ff75f8               | push                dword ptr [ebp - 8]
            //   03d0                 | add                 edx, eax
            //   837d6806             | cmp                 dword ptr [ebp + 0x68], 6
            //   52                   | push                edx
            //   ffb49d2cffffff       | push                dword ptr [ebp + ebx*4 - 0xd4]
            //   7407                 | je                  9

        $sequence_5 = { ff75f8 03d0 837d6806 52 ffb49d2cffffff 7407 e8???????? }
            // n = 7, score = 100
            //   ff75f8               | push                dword ptr [ebp - 8]
            //   03d0                 | add                 edx, eax
            //   837d6806             | cmp                 dword ptr [ebp + 0x68], 6
            //   52                   | push                edx
            //   ffb49d2cffffff       | push                dword ptr [ebp + ebx*4 - 0xd4]
            //   7407                 | je                  9
            //   e8????????           |                     

        $sequence_6 = { e8???????? 8bf8 a1???????? 85c0 752b 8d8424e0000000 }
            // n = 6, score = 100
            //   e8????????           |                     
            //   8bf8                 | mov                 edi, eax
            //   a1????????           |                     
            //   85c0                 | test                eax, eax
            //   752b                 | jne                 0x2d
            //   8d8424e0000000       | lea                 eax, [esp + 0xe0]

        $sequence_7 = { 50 50 50 ffd6 85c0 0f867d010000 8d4801 }
            // n = 7, score = 100
            //   50                   | push                eax
            //   50                   | push                eax
            //   50                   | push                eax
            //   ffd6                 | call                esi
            //   85c0                 | test                eax, eax
            //   0f867d010000         | jbe                 0x183
            //   8d4801               | lea                 ecx, [eax + 1]

        $sequence_8 = { b9???????? 8d85b4fdffff e8???????? e8???????? 894508 eb02 }
            // n = 6, score = 100
            //   b9????????           |                     
            //   8d85b4fdffff         | lea                 eax, [ebp - 0x24c]
            //   e8????????           |                     
            //   e8????????           |                     
            //   894508               | mov                 dword ptr [ebp + 8], eax
            //   eb02                 | jmp                 4

        $sequence_9 = { e8???????? 59 8d4594 50 ba???????? e8???????? }
            // n = 6, score = 100
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   8d4594               | lea                 eax, [ebp - 0x6c]
            //   50                   | push                eax
            //   ba????????           |                     
            //   e8????????           |                     

    condition:
        7 of them and filesize < 326182
}