rule win_nemty_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.nemty."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.nemty"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 6bf61c 8b45e8 03f0 897308 6bff1c }
            // n = 5, score = 300
            //   6bf61c               | imul                esi, esi, 0x1c
            //   8b45e8               | mov                 eax, dword ptr [ebp - 0x18]
            //   03f0                 | add                 esi, eax
            //   897308               | mov                 dword ptr [ebx + 8], esi
            //   6bff1c               | imul                edi, edi, 0x1c

        $sequence_1 = { 53 50 89b5e4d8ffff 889decd8ffff e8???????? 83c40c 8d85e8d8ffff }
            // n = 7, score = 300
            //   53                   | push                ebx
            //   50                   | push                eax
            //   89b5e4d8ffff         | mov                 dword ptr [ebp - 0x271c], esi
            //   889decd8ffff         | mov                 byte ptr [ebp - 0x2714], bl
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   8d85e8d8ffff         | lea                 eax, [ebp - 0x2718]

        $sequence_2 = { 8d45c4 bf???????? e8???????? 6a01 }
            // n = 4, score = 300
            //   8d45c4               | lea                 eax, [ebp - 0x3c]
            //   bf????????           |                     
            //   e8????????           |                     
            //   6a01                 | push                1

        $sequence_3 = { 8d4d0c 837d2010 56 8d3401 8b450c 57 7303 }
            // n = 7, score = 300
            //   8d4d0c               | lea                 ecx, [ebp + 0xc]
            //   837d2010             | cmp                 dword ptr [ebp + 0x20], 0x10
            //   56                   | push                esi
            //   8d3401               | lea                 esi, [ecx + eax]
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   57                   | push                edi
            //   7303                 | jae                 5

        $sequence_4 = { e8???????? 53 8db570ffffff e8???????? 53 }
            // n = 5, score = 300
            //   e8????????           |                     
            //   53                   | push                ebx
            //   8db570ffffff         | lea                 esi, [ebp - 0x90]
            //   e8????????           |                     
            //   53                   | push                ebx

        $sequence_5 = { 7302 8bc7 3bc6 740f }
            // n = 4, score = 300
            //   7302                 | jae                 4
            //   8bc7                 | mov                 eax, edi
            //   3bc6                 | cmp                 eax, esi
            //   740f                 | je                  0x11

        $sequence_6 = { c785e0d8ffff10270000 ff15???????? 837d1c10 8b4508 }
            // n = 4, score = 300
            //   c785e0d8ffff10270000     | mov    dword ptr [ebp - 0x2720], 0x2710
            //   ff15????????         |                     
            //   837d1c10             | cmp                 dword ptr [ebp + 0x1c], 0x10
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]

        $sequence_7 = { 50 ff35???????? ff75a4 56 ff15???????? 56 }
            // n = 6, score = 300
            //   50                   | push                eax
            //   ff35????????         |                     
            //   ff75a4               | push                dword ptr [ebp - 0x5c]
            //   56                   | push                esi
            //   ff15????????         |                     
            //   56                   | push                esi

        $sequence_8 = { 8a07 3a4508 7513 6a01 8d4508 }
            // n = 5, score = 300
            //   8a07                 | mov                 al, byte ptr [edi]
            //   3a4508               | cmp                 al, byte ptr [ebp + 8]
            //   7513                 | jne                 0x15
            //   6a01                 | push                1
            //   8d4508               | lea                 eax, [ebp + 8]

        $sequence_9 = { 68???????? 8d8424a8000000 e8???????? 6a07 5f 33c0 83ec1c }
            // n = 7, score = 300
            //   68????????           |                     
            //   8d8424a8000000       | lea                 eax, [esp + 0xa8]
            //   e8????????           |                     
            //   6a07                 | push                7
            //   5f                   | pop                 edi
            //   33c0                 | xor                 eax, eax
            //   83ec1c               | sub                 esp, 0x1c

    condition:
        7 of them and filesize < 204800
}