rule win_neteagle_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.neteagle."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.neteagle"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 57 6a00 ff15???????? 8b44241c 8d4c2424 6a00 51 }
            // n = 7, score = 100
            //   57                   | push                edi
            //   6a00                 | push                0
            //   ff15????????         |                     
            //   8b44241c             | mov                 eax, dword ptr [esp + 0x1c]
            //   8d4c2424             | lea                 ecx, [esp + 0x24]
            //   6a00                 | push                0
            //   51                   | push                ecx

        $sequence_1 = { 8d4dec e9???????? 8d4dd8 e9???????? 8b45e4 50 }
            // n = 6, score = 100
            //   8d4dec               | lea                 ecx, [ebp - 0x14]
            //   e9????????           |                     
            //   8d4dd8               | lea                 ecx, [ebp - 0x28]
            //   e9????????           |                     
            //   8b45e4               | mov                 eax, dword ptr [ebp - 0x1c]
            //   50                   | push                eax

        $sequence_2 = { 8b4678 8b3d???????? 50 8b4620 6a01 6880000000 }
            // n = 6, score = 100
            //   8b4678               | mov                 eax, dword ptr [esi + 0x78]
            //   8b3d????????         |                     
            //   50                   | push                eax
            //   8b4620               | mov                 eax, dword ptr [esi + 0x20]
            //   6a01                 | push                1
            //   6880000000           | push                0x80

        $sequence_3 = { 50 6a00 6880000000 51 ffd7 6a01 6a00 }
            // n = 7, score = 100
            //   50                   | push                eax
            //   6a00                 | push                0
            //   6880000000           | push                0x80
            //   51                   | push                ecx
            //   ffd7                 | call                edi
            //   6a01                 | push                1
            //   6a00                 | push                0

        $sequence_4 = { c684241c02000002 8b70f8 81fe00010000 7e1d 8bb42424020000 }
            // n = 5, score = 100
            //   c684241c02000002     | mov                 byte ptr [esp + 0x21c], 2
            //   8b70f8               | mov                 esi, dword ptr [eax - 8]
            //   81fe00010000         | cmp                 esi, 0x100
            //   7e1d                 | jle                 0x1f
            //   8bb42424020000       | mov                 esi, dword ptr [esp + 0x224]

        $sequence_5 = { 52 50 ffd5 6a07 8d8c2428010000 68???????? }
            // n = 6, score = 100
            //   52                   | push                edx
            //   50                   | push                eax
            //   ffd5                 | call                ebp
            //   6a07                 | push                7
            //   8d8c2428010000       | lea                 ecx, [esp + 0x128]
            //   68????????           |                     

        $sequence_6 = { e8???????? 8d4c2420 c644243c01 e8???????? 8b442414 bf???????? 8a10 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8d4c2420             | lea                 ecx, [esp + 0x20]
            //   c644243c01           | mov                 byte ptr [esp + 0x3c], 1
            //   e8????????           |                     
            //   8b442414             | mov                 eax, dword ptr [esp + 0x14]
            //   bf????????           |                     
            //   8a10                 | mov                 dl, byte ptr [eax]

        $sequence_7 = { 8d4c2418 c644245801 e8???????? 8d4c2434 e8???????? 8d542464 }
            // n = 6, score = 100
            //   8d4c2418             | lea                 ecx, [esp + 0x18]
            //   c644245801           | mov                 byte ptr [esp + 0x58], 1
            //   e8????????           |                     
            //   8d4c2434             | lea                 ecx, [esp + 0x34]
            //   e8????????           |                     
            //   8d542464             | lea                 edx, [esp + 0x64]

        $sequence_8 = { 52 8944244c e8???????? 8d4c2414 c644243803 e8???????? }
            // n = 6, score = 100
            //   52                   | push                edx
            //   8944244c             | mov                 dword ptr [esp + 0x4c], eax
            //   e8????????           |                     
            //   8d4c2414             | lea                 ecx, [esp + 0x14]
            //   c644243803           | mov                 byte ptr [esp + 0x38], 3
            //   e8????????           |                     

        $sequence_9 = { 8964242c 51 8d4c2434 e8???????? 8d542428 8bce 52 }
            // n = 7, score = 100
            //   8964242c             | mov                 dword ptr [esp + 0x2c], esp
            //   51                   | push                ecx
            //   8d4c2434             | lea                 ecx, [esp + 0x34]
            //   e8????????           |                     
            //   8d542428             | lea                 edx, [esp + 0x28]
            //   8bce                 | mov                 ecx, esi
            //   52                   | push                edx

    condition:
        7 of them and filesize < 262144
}