rule win_netsupportmanager_rat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.netsupportmanager_rat."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.netsupportmanager_rat"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 8b9630010000 6a00 52 e8???????? 8b4614 83c420 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8b9630010000         | mov                 edx, dword ptr [esi + 0x130]
            //   6a00                 | push                0
            //   52                   | push                edx
            //   e8????????           |                     
            //   8b4614               | mov                 eax, dword ptr [esi + 0x14]
            //   83c420               | add                 esp, 0x20

        $sequence_1 = { f6868000000002 745a f6868402000007 7451 8b4e68 8b3d???????? 6a03 }
            // n = 7, score = 100
            //   f6868000000002       | test                byte ptr [esi + 0x80], 2
            //   745a                 | je                  0x5c
            //   f6868402000007       | test                byte ptr [esi + 0x284], 7
            //   7451                 | je                  0x53
            //   8b4e68               | mov                 ecx, dword ptr [esi + 0x68]
            //   8b3d????????         |                     
            //   6a03                 | push                3

        $sequence_2 = { e8???????? eb4b 894508 894e1c 8945f0 85c0 c645fc05 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   eb4b                 | jmp                 0x4d
            //   894508               | mov                 dword ptr [ebp + 8], eax
            //   894e1c               | mov                 dword ptr [esi + 0x1c], ecx
            //   8945f0               | mov                 dword ptr [ebp - 0x10], eax
            //   85c0                 | test                eax, eax
            //   c645fc05             | mov                 byte ptr [ebp - 4], 5

        $sequence_3 = { e8???????? e9???????? 8b06 8d4d08 51 8bce ff9098000000 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   e9????????           |                     
            //   8b06                 | mov                 eax, dword ptr [esi]
            //   8d4d08               | lea                 ecx, [ebp + 8]
            //   51                   | push                ecx
            //   8bce                 | mov                 ecx, esi
            //   ff9098000000         | call                dword ptr [eax + 0x98]

        $sequence_4 = { e8???????? c705????????01000000 8b15???????? 52 ff15???????? 5f 5e }
            // n = 7, score = 100
            //   e8????????           |                     
            //   c705????????01000000     |     
            //   8b15????????         |                     
            //   52                   | push                edx
            //   ff15????????         |                     
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi

        $sequence_5 = { e8???????? 8b45fc 8b4df4 8bd0 2bd1 52 8b55f8 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   8b4df4               | mov                 ecx, dword ptr [ebp - 0xc]
            //   8bd0                 | mov                 edx, eax
            //   2bd1                 | sub                 edx, ecx
            //   52                   | push                edx
            //   8b55f8               | mov                 edx, dword ptr [ebp - 8]

        $sequence_6 = { ff15???????? 8b4e28 6810200000 57 8d8500ffffff 6aff 50 }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   8b4e28               | mov                 ecx, dword ptr [esi + 0x28]
            //   6810200000           | push                0x2010
            //   57                   | push                edi
            //   8d8500ffffff         | lea                 eax, [ebp - 0x100]
            //   6aff                 | push                -1
            //   50                   | push                eax

        $sequence_7 = { ff15???????? eb03 8b5de0 c745fcffffffff e8???????? 33c0 8b8d60ffffff }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   eb03                 | jmp                 5
            //   8b5de0               | mov                 ebx, dword ptr [ebp - 0x20]
            //   c745fcffffffff       | mov                 dword ptr [ebp - 4], 0xffffffff
            //   e8????????           |                     
            //   33c0                 | xor                 eax, eax
            //   8b8d60ffffff         | mov                 ecx, dword ptr [ebp - 0xa0]

        $sequence_8 = { ff5008 8d4ddc e8???????? 8b45dc 8d4ddc ff10 84c0 }
            // n = 7, score = 100
            //   ff5008               | call                dword ptr [eax + 8]
            //   8d4ddc               | lea                 ecx, [ebp - 0x24]
            //   e8????????           |                     
            //   8b45dc               | mov                 eax, dword ptr [ebp - 0x24]
            //   8d4ddc               | lea                 ecx, [ebp - 0x24]
            //   ff10                 | call                dword ptr [eax]
            //   84c0                 | test                al, al

        $sequence_9 = { f3a5 8bc8 83e103 f3a4 81fa03000d00 750d 8d55c4 }
            // n = 7, score = 100
            //   f3a5                 | rep movsd           dword ptr es:[edi], dword ptr [esi]
            //   8bc8                 | mov                 ecx, eax
            //   83e103               | and                 ecx, 3
            //   f3a4                 | rep movsb           byte ptr es:[edi], byte ptr [esi]
            //   81fa03000d00         | cmp                 edx, 0xd0003
            //   750d                 | jne                 0xf
            //   8d55c4               | lea                 edx, [ebp - 0x3c]

    condition:
        7 of them and filesize < 4734976
}