rule win_nettraveler_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.nettraveler."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.nettraveler"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 72ed 8bc3 5e 5b c9 c3 }
            // n = 6, score = 100
            //   72ed                 | jb                  0xffffffef
            //   8bc3                 | mov                 eax, ebx
            //   5e                   | pop                 esi
            //   5b                   | pop                 ebx
            //   c9                   | leave               
            //   c3                   | ret                 

        $sequence_1 = { ffd6 59 50 8d85f8feffff 50 ffd6 59 }
            // n = 7, score = 100
            //   ffd6                 | call                esi
            //   59                   | pop                 ecx
            //   50                   | push                eax
            //   8d85f8feffff         | lea                 eax, [ebp - 0x108]
            //   50                   | push                eax
            //   ffd6                 | call                esi
            //   59                   | pop                 ecx

        $sequence_2 = { 720a 80f939 7705 80c1d0 eb1c 80f961 720a }
            // n = 7, score = 100
            //   720a                 | jb                  0xc
            //   80f939               | cmp                 cl, 0x39
            //   7705                 | ja                  7
            //   80c1d0               | add                 cl, 0xd0
            //   eb1c                 | jmp                 0x1e
            //   80f961               | cmp                 cl, 0x61
            //   720a                 | jb                  0xc

        $sequence_3 = { ff75dc ff15???????? 8b45ec 5f 5b 5e c9 }
            // n = 7, score = 100
            //   ff75dc               | push                dword ptr [ebp - 0x24]
            //   ff15????????         |                     
            //   8b45ec               | mov                 eax, dword ptr [ebp - 0x14]
            //   5f                   | pop                 edi
            //   5b                   | pop                 ebx
            //   5e                   | pop                 esi
            //   c9                   | leave               

        $sequence_4 = { 50 8d45f4 c745f004000000 50 6813000020 ff750c }
            // n = 6, score = 100
            //   50                   | push                eax
            //   8d45f4               | lea                 eax, [ebp - 0xc]
            //   c745f004000000       | mov                 dword ptr [ebp - 0x10], 4
            //   50                   | push                eax
            //   6813000020           | push                0x20000013
            //   ff750c               | push                dword ptr [ebp + 0xc]

        $sequence_5 = { 83c40c 6a0a ffd6 8d442418 50 ff742414 ffd3 }
            // n = 7, score = 100
            //   83c40c               | add                 esp, 0xc
            //   6a0a                 | push                0xa
            //   ffd6                 | call                esi
            //   8d442418             | lea                 eax, [esp + 0x18]
            //   50                   | push                eax
            //   ff742414             | push                dword ptr [esp + 0x14]
            //   ffd3                 | call                ebx

        $sequence_6 = { 80a5dcf3ffff00 f3ab 66ab aa 8bca 33c0 }
            // n = 6, score = 100
            //   80a5dcf3ffff00       | and                 byte ptr [ebp - 0xc24], 0
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   66ab                 | stosw               word ptr es:[edi], ax
            //   aa                   | stosb               byte ptr es:[edi], al
            //   8bca                 | mov                 ecx, edx
            //   33c0                 | xor                 eax, eax

        $sequence_7 = { 8975f8 8975e4 8975d0 8975c8 8975e8 bf04010000 8d45c8 }
            // n = 7, score = 100
            //   8975f8               | mov                 dword ptr [ebp - 8], esi
            //   8975e4               | mov                 dword ptr [ebp - 0x1c], esi
            //   8975d0               | mov                 dword ptr [ebp - 0x30], esi
            //   8975c8               | mov                 dword ptr [ebp - 0x38], esi
            //   8975e8               | mov                 dword ptr [ebp - 0x18], esi
            //   bf04010000           | mov                 edi, 0x104
            //   8d45c8               | lea                 eax, [ebp - 0x38]

        $sequence_8 = { 46 46 83ff10 7ce3 6a08 b8???????? 59 }
            // n = 7, score = 100
            //   46                   | inc                 esi
            //   46                   | inc                 esi
            //   83ff10               | cmp                 edi, 0x10
            //   7ce3                 | jl                  0xffffffe5
            //   6a08                 | push                8
            //   b8????????           |                     
            //   59                   | pop                 ecx

        $sequence_9 = { 59 50 8d8580f1ffff 50 ff750c ff15???????? 8945fc }
            // n = 7, score = 100
            //   59                   | pop                 ecx
            //   50                   | push                eax
            //   8d8580f1ffff         | lea                 eax, [ebp - 0xe80]
            //   50                   | push                eax
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   ff15????????         |                     
            //   8945fc               | mov                 dword ptr [ebp - 4], eax

    condition:
        7 of them and filesize < 106496
}