rule win_netwire_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.netwire."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.netwire"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? c7042446000000 e8???????? c7042449000000 e8???????? }
            // n = 5, score = 1200
            //   e8????????           |                     
            //   c7042446000000       | mov                 dword ptr [esp], 0x46
            //   e8????????           |                     
            //   c7042449000000       | mov                 dword ptr [esp], 0x49
            //   e8????????           |                     

        $sequence_1 = { e8???????? c7442410000000f0 c744240c01000000 c744240800000000 c744240400000000 }
            // n = 5, score = 1200
            //   e8????????           |                     
            //   c7442410000000f0     | mov                 dword ptr [esp + 0x10], 0xf0000000
            //   c744240c01000000     | mov                 dword ptr [esp + 0xc], 1
            //   c744240800000000     | mov                 dword ptr [esp + 8], 0
            //   c744240400000000     | mov                 dword ptr [esp + 4], 0

        $sequence_2 = { c70424d0070000 e8???????? e9???????? e8???????? }
            // n = 4, score = 1200
            //   c70424d0070000       | mov                 dword ptr [esp], 0x7d0
            //   e8????????           |                     
            //   e9????????           |                     
            //   e8????????           |                     

        $sequence_3 = { 89442404 c70424???????? e8???????? a3???????? }
            // n = 4, score = 1200
            //   89442404             | mov                 dword ptr [esp + 4], eax
            //   c70424????????       |                     
            //   e8????????           |                     
            //   a3????????           |                     

        $sequence_4 = { 890424 e8???????? 83ec10 83f806 }
            // n = 4, score = 1200
            //   890424               | mov                 dword ptr [esp], eax
            //   e8????????           |                     
            //   83ec10               | sub                 esp, 0x10
            //   83f806               | cmp                 eax, 6

        $sequence_5 = { c7042401000080 e8???????? c7042410000000 e8???????? }
            // n = 4, score = 1200
            //   c7042401000080       | mov                 dword ptr [esp], 0x80000001
            //   e8????????           |                     
            //   c7042410000000       | mov                 dword ptr [esp], 0x10
            //   e8????????           |                     

        $sequence_6 = { 85c0 750f c705????????05000000 e9???????? c705????????00000000 }
            // n = 5, score = 1200
            //   85c0                 | test                eax, eax
            //   750f                 | jne                 0x11
            //   c705????????05000000     |     
            //   e9????????           |                     
            //   c705????????00000000     |     

        $sequence_7 = { 890424 e8???????? eb11 c7042496000000 e8???????? }
            // n = 5, score = 1200
            //   890424               | mov                 dword ptr [esp], eax
            //   e8????????           |                     
            //   eb11                 | jmp                 0x13
            //   c7042496000000       | mov                 dword ptr [esp], 0x96
            //   e8????????           |                     

        $sequence_8 = { c744241000000000 c744240c00000000 c744240800000000 c744240400000000 c7042440000000 }
            // n = 5, score = 1200
            //   c744241000000000     | mov                 dword ptr [esp + 0x10], 0
            //   c744240c00000000     | mov                 dword ptr [esp + 0xc], 0
            //   c744240800000000     | mov                 dword ptr [esp + 8], 0
            //   c744240400000000     | mov                 dword ptr [esp + 4], 0
            //   c7042440000000       | mov                 dword ptr [esp], 0x40

        $sequence_9 = { a3???????? e9???????? c705????????00000000 e9???????? c7042410020000 }
            // n = 5, score = 1200
            //   a3????????           |                     
            //   e9????????           |                     
            //   c705????????00000000     |     
            //   e9????????           |                     
            //   c7042410020000       | mov                 dword ptr [esp], 0x210

    condition:
        7 of them and filesize < 416768
}