rule win_newsreels_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.newsreels."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.newsreels"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 895144 8bc2 8a542404 88540848 8b4144 }
            // n = 5, score = 100
            //   895144               | mov                 dword ptr [ecx + 0x44], edx
            //   8bc2                 | mov                 eax, edx
            //   8a542404             | mov                 dl, byte ptr [esp + 4]
            //   88540848             | mov                 byte ptr [eax + ecx + 0x48], dl
            //   8b4144               | mov                 eax, dword ptr [ecx + 0x44]

        $sequence_1 = { 33c0 5b 81c40c050000 c3 8d4c2418 51 6804010000 }
            // n = 7, score = 100
            //   33c0                 | xor                 eax, eax
            //   5b                   | pop                 ebx
            //   81c40c050000         | add                 esp, 0x50c
            //   c3                   | ret                 
            //   8d4c2418             | lea                 ecx, [esp + 0x18]
            //   51                   | push                ecx
            //   6804010000           | push                0x104

        $sequence_2 = { c6043000 5e 5d 5b 81c4a0010000 c3 }
            // n = 6, score = 100
            //   c6043000             | mov                 byte ptr [eax + esi], 0
            //   5e                   | pop                 esi
            //   5d                   | pop                 ebp
            //   5b                   | pop                 ebx
            //   81c4a0010000         | add                 esp, 0x1a0
            //   c3                   | ret                 

        $sequence_3 = { 8d542428 52 89442430 e8???????? 8d442474 }
            // n = 5, score = 100
            //   8d542428             | lea                 edx, [esp + 0x28]
            //   52                   | push                edx
            //   89442430             | mov                 dword ptr [esp + 0x30], eax
            //   e8????????           |                     
            //   8d442474             | lea                 eax, [esp + 0x74]

        $sequence_4 = { 53 e8???????? 83c414 3bf5 75a4 }
            // n = 5, score = 100
            //   53                   | push                ebx
            //   e8????????           |                     
            //   83c414               | add                 esp, 0x14
            //   3bf5                 | cmp                 esi, ebp
            //   75a4                 | jne                 0xffffffa6

        $sequence_5 = { 8d7048 8ad1 57 8b7804 8816 8b5010 41 }
            // n = 7, score = 100
            //   8d7048               | lea                 esi, [eax + 0x48]
            //   8ad1                 | mov                 dl, cl
            //   57                   | push                edi
            //   8b7804               | mov                 edi, dword ptr [eax + 4]
            //   8816                 | mov                 byte ptr [esi], dl
            //   8b5010               | mov                 edx, dword ptr [eax + 0x10]
            //   41                   | inc                 ecx

        $sequence_6 = { 3d???????? 8a143a 88540c07 7cec b910000000 }
            // n = 5, score = 100
            //   3d????????           |                     
            //   8a143a               | mov                 dl, byte ptr [edx + edi]
            //   88540c07             | mov                 byte ptr [esp + ecx + 7], dl
            //   7cec                 | jl                  0xffffffee
            //   b910000000           | mov                 ecx, 0x10

        $sequence_7 = { ffd6 85c0 0f84c1000000 8b3d???????? 53 8d442424 }
            // n = 6, score = 100
            //   ffd6                 | call                esi
            //   85c0                 | test                eax, eax
            //   0f84c1000000         | je                  0xc7
            //   8b3d????????         |                     
            //   53                   | push                ebx
            //   8d442424             | lea                 eax, [esp + 0x24]

        $sequence_8 = { 8b742410 33c0 8ada 8ac8 }
            // n = 4, score = 100
            //   8b742410             | mov                 esi, dword ptr [esp + 0x10]
            //   33c0                 | xor                 eax, eax
            //   8ada                 | mov                 bl, dl
            //   8ac8                 | mov                 cl, al

        $sequence_9 = { 56 8bf1 8b4e18 8b5614 }
            // n = 4, score = 100
            //   56                   | push                esi
            //   8bf1                 | mov                 esi, ecx
            //   8b4e18               | mov                 ecx, dword ptr [esi + 0x18]
            //   8b5614               | mov                 edx, dword ptr [esi + 0x14]

    condition:
        7 of them and filesize < 65536
}