rule win_nexster_bot_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.nexster_bot."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.nexster_bot"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 52 e8???????? 68ff030000 8d85bd090000 }
            // n = 4, score = 100
            //   52                   | push                edx
            //   e8????????           |                     
            //   68ff030000           | push                0x3ff
            //   8d85bd090000         | lea                 eax, [ebp + 0x9bd]

        $sequence_1 = { ff15???????? 668985ae010000 6a10 8d85ac010000 50 57 }
            // n = 6, score = 100
            //   ff15????????         |                     
            //   668985ae010000       | mov                 word ptr [ebp + 0x1ae], ax
            //   6a10                 | push                0x10
            //   8d85ac010000         | lea                 eax, [ebp + 0x1ac]
            //   50                   | push                eax
            //   57                   | push                edi

        $sequence_2 = { 7d10 668b4c4310 66890c45186e4100 40 ebe8 33c0 }
            // n = 6, score = 100
            //   7d10                 | jge                 0x12
            //   668b4c4310           | mov                 cx, word ptr [ebx + eax*2 + 0x10]
            //   66890c45186e4100     | mov                 word ptr [eax*2 + 0x416e18], cx
            //   40                   | inc                 eax
            //   ebe8                 | jmp                 0xffffffea
            //   33c0                 | xor                 eax, eax

        $sequence_3 = { 03f9 837d1810 7208 8b5d04 }
            // n = 4, score = 100
            //   03f9                 | add                 edi, ecx
            //   837d1810             | cmp                 dword ptr [ebp + 0x18], 0x10
            //   7208                 | jb                  0xa
            //   8b5d04               | mov                 ebx, dword ptr [ebp + 4]

        $sequence_4 = { 33c0 8da42400000000 8a1485d0604100 889405000e0000 40 83f80b }
            // n = 6, score = 100
            //   33c0                 | xor                 eax, eax
            //   8da42400000000       | lea                 esp, [esp]
            //   8a1485d0604100       | mov                 dl, byte ptr [eax*4 + 0x4160d0]
            //   889405000e0000       | mov                 byte ptr [ebp + eax + 0xe00], dl
            //   40                   | inc                 eax
            //   83f80b               | cmp                 eax, 0xb

        $sequence_5 = { 731a 8bc8 83e01f c1f905 8b0c8d20804100 c1e006 03c1 }
            // n = 7, score = 100
            //   731a                 | jae                 0x1c
            //   8bc8                 | mov                 ecx, eax
            //   83e01f               | and                 eax, 0x1f
            //   c1f905               | sar                 ecx, 5
            //   8b0c8d20804100       | mov                 ecx, dword ptr [ecx*4 + 0x418020]
            //   c1e006               | shl                 eax, 6
            //   03c1                 | add                 eax, ecx

        $sequence_6 = { 81c404040000 c3 53 56 57 8bf8 }
            // n = 6, score = 100
            //   81c404040000         | add                 esp, 0x404
            //   c3                   | ret                 
            //   53                   | push                ebx
            //   56                   | push                esi
            //   57                   | push                edi
            //   8bf8                 | mov                 edi, eax

        $sequence_7 = { 66898c24bc010000 e9???????? 8b15???????? a1???????? 8b0d???????? 899424b0010000 }
            // n = 6, score = 100
            //   66898c24bc010000     | mov                 word ptr [esp + 0x1bc], cx
            //   e9????????           |                     
            //   8b15????????         |                     
            //   a1????????           |                     
            //   8b0d????????         |                     
            //   899424b0010000       | mov                 dword ptr [esp + 0x1b0], edx

        $sequence_8 = { 68???????? 52 e8???????? 68???????? 8d85bc110000 50 }
            // n = 6, score = 100
            //   68????????           |                     
            //   52                   | push                edx
            //   e8????????           |                     
            //   68????????           |                     
            //   8d85bc110000         | lea                 eax, [ebp + 0x11bc]
            //   50                   | push                eax

        $sequence_9 = { 8a08 40 84c9 75f9 8dbdbc150000 2bc6 4f }
            // n = 7, score = 100
            //   8a08                 | mov                 cl, byte ptr [eax]
            //   40                   | inc                 eax
            //   84c9                 | test                cl, cl
            //   75f9                 | jne                 0xfffffffb
            //   8dbdbc150000         | lea                 edi, [ebp + 0x15bc]
            //   2bc6                 | sub                 eax, esi
            //   4f                   | dec                 edi

    condition:
        7 of them and filesize < 245760
}