rule win_nightsky_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.nightsky."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.nightsky"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 66d3db 310c24 5b f5 4863c9 }
            // n = 5, score = 100
            //   66d3db               | add                 dword ptr [eax], eax
            //   310c24               | add                 byte ptr [eax], al
            //   5b                   | dec                 esp
            //   f5                   | bsf                 edx, edx
            //   4863c9               | dec                 eax

        $sequence_1 = { ba08000000 ff15???????? 4c8bf0 4885c0 74e2 488b542460 488bc8 }
            // n = 7, score = 100
            //   ba08000000           | mov                 ch, byte ptr [edi]
            //   ff15????????         |                     
            //   4c8bf0               | dec                 esp
            //   4885c0               | lea                 esi, [0x2154c]
            //   74e2                 | mov                 word ptr [ebp - 0x40], dx
            //   488b542460           | dec                 ebx
            //   488bc8               | mov                 edx, dword ptr [esi + edi*8]

        $sequence_2 = { 8bcf 48f7d0 b8f4400625 f8 d3c0 4002c7 32042a }
            // n = 7, score = 100
            //   8bcf                 | dec                 esp
            //   48f7d0               | mov                 dword ptr [ebp - 0x10], edi
            //   b8f4400625           | inc                 ebp
            //   f8                   | xor                 edx, dword ptr [ebp + edx*4 + 0x57910]
            //   d3c0                 | inc                 ebp
            //   4002c7               | xor                 edx, dword ptr [ebp + ecx*4 + 0x56910]
            //   32042a               | mov                 dword ptr [ebp - 0x24], esi

        $sequence_3 = { 41c743e001020304 488d4c2430 41c743e401020304 e8???????? 41b880000000 488d4c2430 488bd7 }
            // n = 7, score = 100
            //   41c743e001020304     | arpl                di, si
            //   488d4c2430           | inc                 eax
            //   41c743e401020304     | sub                 dh, bl
            //   e8????????           |                     
            //   41b880000000         | inc                 ecx
            //   488d4c2430           | xor                 edx, 0x6e290113
            //   488bd7               | inc                 ecx

        $sequence_4 = { 4889442440 4c8d0543150500 488d85b0230000 4889442438 488d15f01e0000 48c744243010000000 e8???????? }
            // n = 7, score = 100
            //   4889442440           | lea                 eax, [0x20e49]
            //   4c8d0543150500       | je                  0x58
            //   488d85b0230000       | dec                 eax
            //   4889442438           | lea                 eax, [0x211c0]
            //   488d15f01e0000       | dec                 eax
            //   48c744243010000000     | cmp    ecx, eax
            //   e8????????           |                     

        $sequence_5 = { 4983f940 72eb e9???????? 488d059e1f0000 48b90000000000000080 488987c8000000 488d0576900200 }
            // n = 7, score = 100
            //   4983f940             | dec                 eax
            //   72eb                 | lea                 eax, [0xdd69]
            //   e9????????           |                     
            //   488d059e1f0000       | dec                 eax
            //   48b90000000000000080     | mov    dword ptr [edi], eax
            //   488987c8000000       | dec                 eax
            //   488d0576900200       | lea                 ecx, [edi + 0x18]

        $sequence_6 = { b9ffffffff 33ff 4981fffc34d65d 49f7c41926f25d 44894c2420 }
            // n = 5, score = 100
            //   b9ffffffff           | inc                 ebp
            //   33ff                 | test                ebx, ebx
            //   4981fffc34d65d       | js                  0x29f
            //   49f7c41926f25d       | dec                 esp
            //   44894c2420           | mov                 dword ptr [esp + 0x20], esp

        $sequence_7 = { 4c8d1d5f570100 4803ed 41ba04000000 4d8d44ed10 498bc8 413818 7431 }
            // n = 7, score = 100
            //   4c8d1d5f570100       | mov                 eax, 0x120
            //   4803ed               | dec                 eax
            //   41ba04000000         | mov                 dword ptr [esp + 0x28], eax
            //   4d8d44ed10           | dec                 eax
            //   498bc8               | mov                 dword ptr [esp + 0x30], eax
            //   413818               | dec                 ecx
            //   7431                 | mov                 edi, ecx

        $sequence_8 = { 7505 488be9 eb03 4803ed b808000000 48f7e5 490f40c0 }
            // n = 7, score = 100
            //   7505                 | inc                 eax
            //   488be9               | xchg                dh, bh
            //   eb03                 | dec                 ecx
            //   4803ed               | and                 ebx, 0xfffffff0
            //   b808000000           | inc                 sp
            //   48f7e5               | bts                 edi, esi
            //   490f40c0             | inc                 eax

        $sequence_9 = { 418bca 48c1e910 83e13f 4533848ea0700400 418bca 48c1e908 4183e23f }
            // n = 7, score = 100
            //   418bca               | movzx               esi, dx
            //   48c1e910             | inc                 ecx
            //   83e13f               | push                esi
            //   4533848ea0700400     | inc                 ecx
            //   418bca               | push                ebx
            //   48c1e908             | dec                 ebp
            //   4183e23f             | movzx               ebx, cx

    condition:
        7 of them and filesize < 19536896
}