rule win_nimrev_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.nimrev."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.nimrev"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c1e002 01d0 01c0 29c1 89c8 83c030 }
            // n = 6, score = 200
            //   c1e002               | mov                 dword ptr [ebp - 0x24], 0xa42
            //   01d0                 | mov                 dword ptr [ebp - 0x20], 0x4235f0
            //   01c0                 | mov                 dword ptr [ebp - 0x10], 0
            //   29c1                 | mov                 dword ptr [esp], eax
            //   89c8                 | mov                 dword ptr [ebp - 0xc], 0
            //   83c030               | mov                 dword ptr [ebp - 0x24], 0x25f

        $sequence_1 = { ffd0 90 e9???????? 90 }
            // n = 4, score = 200
            //   ffd0                 | mov                 byte ptr [ebp - 5], 0
            //   90                   | cmp                 dword ptr [ebp + 8], 0
            //   e9????????           |                     
            //   90                   | sete                al

        $sequence_2 = { 89c1 e8???????? eb04 90 eb01 }
            // n = 5, score = 200
            //   89c1                 | dec                 eax
            //   e8????????           |                     
            //   eb04                 | mov                 dword ptr [esp + 0x20], edx
            //   90                   | inc                 ecx
            //   eb01                 | mov                 ecx, 1

        $sequence_3 = { e8???????? e8???????? eb04 90 eb01 }
            // n = 5, score = 200
            //   e8????????           |                     
            //   e8????????           |                     
            //   eb04                 | jmp                 0x12e8
            //   90                   | nop                 
            //   eb01                 | jmp                 0x12e8

        $sequence_4 = { 83f001 84c0 7408 90 e8???????? eb01 }
            // n = 6, score = 200
            //   83f001               | dec                 eax
            //   84c0                 | lea                 eax, [0x8070]
            //   7408                 | dec                 eax
            //   90                   | mov                 dword ptr [ebp + 8], eax
            //   e8????????           |                     
            //   eb01                 | dec                 eax

        $sequence_5 = { 0f95c0 8845f7 eb01 90 807df700 }
            // n = 5, score = 200
            //   0f95c0               | dec                 eax
            //   8845f7               | lea                 eax, [0xa255]
            //   eb01                 | mov                 byte ptr [ebp - 1], al
            //   90                   | cmp                 byte ptr [ebp - 1], 0
            //   807df700             | jne                 0x366

        $sequence_6 = { 8b45ec ba00000000 89c1 e8???????? }
            // n = 4, score = 200
            //   8b45ec               | mov                 dword ptr [ebp - 0x24], 0x1cf
            //   ba00000000           | mov                 dword ptr [ebp - 0x20], 0x4246f6
            //   89c1                 | cmp                 dword ptr [ebp - 0x10], 0
            //   e8????????           |                     

        $sequence_7 = { 0f93c0 83f001 84c0 7408 90 e8???????? eb01 }
            // n = 7, score = 200
            //   0f93c0               | mov                 dword ptr [ebp - 0x50], 0x422a4f
            //   83f001               | mov                 dword ptr [ebp - 0x50], 0x422a4f
            //   84c0                 | mov                 eax, dword ptr [ebp - 0x6c]
            //   7408                 | mov                 eax, dword ptr [eax + 0x1898]
            //   90                   | mov                 edx, 0x3f000000
            //   e8????????           |                     
            //   eb01                 | cmp                 eax, 0x3f000000

        $sequence_8 = { 0f93c0 83f001 84c0 7408 90 e8???????? }
            // n = 6, score = 200
            //   0f93c0               | nop                 
            //   83f001               | mov                 dword ptr [ebp - 0x24], 0xc9
            //   84c0                 | mov                 dword ptr [ebp - 0x20], 0x422a4f
            //   7408                 | mov                 eax, dword ptr [ebp - 0x3c]
            //   90                   | mov                 edx, dword ptr [ebp - 0xc]
            //   e8????????           |                     

        $sequence_9 = { 83f001 84c0 7408 90 }
            // n = 4, score = 200
            //   83f001               | dec                 eax
            //   84c0                 | mov                 dword ptr [ebp - 0x38], eax
            //   7408                 | dec                 eax
            //   90                   | mov                 dword ptr [ebp + 0xa0], 0

    condition:
        7 of them and filesize < 1141760
}