rule win_nitlove_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.nitlove."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.nitlove"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ffd0 8d85c4fdffff baeb9b12fe 50 }
            // n = 4, score = 200
            //   ffd0                 | call                eax
            //   8d85c4fdffff         | lea                 eax, [ebp - 0x23c]
            //   baeb9b12fe           | mov                 edx, 0xfe129beb
            //   50                   | push                eax

        $sequence_1 = { 50 8bd6 e8???????? ffd0 83c40c 8d85fcfcffff }
            // n = 6, score = 200
            //   50                   | push                eax
            //   8bd6                 | mov                 edx, esi
            //   e8????????           |                     
            //   ffd0                 | call                eax
            //   83c40c               | add                 esp, 0xc
            //   8d85fcfcffff         | lea                 eax, [ebp - 0x304]

        $sequence_2 = { ba8be20580 b9???????? e8???????? ffd0 85f6 7451 }
            // n = 6, score = 200
            //   ba8be20580           | mov                 edx, 0x8005e28b
            //   b9????????           |                     
            //   e8????????           |                     
            //   ffd0                 | call                eax
            //   85f6                 | test                esi, esi
            //   7451                 | je                  0x53

        $sequence_3 = { ffd0 8b45d0 85c0 7452 8b75fc 897ddc 2bf7 }
            // n = 7, score = 200
            //   ffd0                 | call                eax
            //   8b45d0               | mov                 eax, dword ptr [ebp - 0x30]
            //   85c0                 | test                eax, eax
            //   7452                 | je                  0x54
            //   8b75fc               | mov                 esi, dword ptr [ebp - 4]
            //   897ddc               | mov                 dword ptr [ebp - 0x24], edi
            //   2bf7                 | sub                 esi, edi

        $sequence_4 = { 7d07 46 8bfe 3bf3 }
            // n = 4, score = 200
            //   7d07                 | jge                 9
            //   46                   | inc                 esi
            //   8bfe                 | mov                 edi, esi
            //   3bf3                 | cmp                 esi, ebx

        $sequence_5 = { e8???????? ffd0 8b15???????? 8bf0 8d45fc }
            // n = 5, score = 200
            //   e8????????           |                     
            //   ffd0                 | call                eax
            //   8b15????????         |                     
            //   8bf0                 | mov                 esi, eax
            //   8d45fc               | lea                 eax, [ebp - 4]

        $sequence_6 = { 56 57 8d859cfeffff c745a444000000 68???????? 50 baeb9b12fe }
            // n = 7, score = 200
            //   56                   | push                esi
            //   57                   | push                edi
            //   8d859cfeffff         | lea                 eax, [ebp - 0x164]
            //   c745a444000000       | mov                 dword ptr [ebp - 0x5c], 0x44
            //   68????????           |                     
            //   50                   | push                eax
            //   baeb9b12fe           | mov                 edx, 0xfe129beb

        $sequence_7 = { 83f80e 7c43 8d4d08 e8???????? }
            // n = 4, score = 200
            //   83f80e               | cmp                 eax, 0xe
            //   7c43                 | jl                  0x45
            //   8d4d08               | lea                 ecx, [ebp + 8]
            //   e8????????           |                     

        $sequence_8 = { ebeb 0fb64608 48 740c 48 740c }
            // n = 6, score = 200
            //   ebeb                 | jmp                 0xffffffed
            //   0fb64608             | movzx               eax, byte ptr [esi + 8]
            //   48                   | dec                 eax
            //   740c                 | je                  0xe
            //   48                   | dec                 eax
            //   740c                 | je                  0xe

        $sequence_9 = { 8955fc 8b473c 8b443878 03c7 8b481c 03cf 894dec }
            // n = 7, score = 200
            //   8955fc               | mov                 dword ptr [ebp - 4], edx
            //   8b473c               | mov                 eax, dword ptr [edi + 0x3c]
            //   8b443878             | mov                 eax, dword ptr [eax + edi + 0x78]
            //   03c7                 | add                 eax, edi
            //   8b481c               | mov                 ecx, dword ptr [eax + 0x1c]
            //   03cf                 | add                 ecx, edi
            //   894dec               | mov                 dword ptr [ebp - 0x14], ecx

    condition:
        7 of them and filesize < 49152
}