rule win_no_justice_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.no_justice."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.no_justice"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b45b4 8a0a 884c382e 8b45bc 8b048570be4100 804c382d04 }
            // n = 6, score = 100
            //   8b45b4               | mov                 eax, dword ptr [ebp - 0x4c]
            //   8a0a                 | mov                 cl, byte ptr [edx]
            //   884c382e             | mov                 byte ptr [eax + edi + 0x2e], cl
            //   8b45bc               | mov                 eax, dword ptr [ebp - 0x44]
            //   8b048570be4100       | mov                 eax, dword ptr [eax*4 + 0x41be70]
            //   804c382d04           | or                  byte ptr [eax + edi + 0x2d], 4

        $sequence_1 = { 83e03f c1f906 6bc038 03048d70be4100 }
            // n = 4, score = 100
            //   83e03f               | and                 eax, 0x3f
            //   c1f906               | sar                 ecx, 6
            //   6bc038               | imul                eax, eax, 0x38
            //   03048d70be4100       | add                 eax, dword ptr [ecx*4 + 0x41be70]

        $sequence_2 = { 6bc938 53 56 8b048570be4100 8b7508 57 }
            // n = 6, score = 100
            //   6bc938               | imul                ecx, ecx, 0x38
            //   53                   | push                ebx
            //   56                   | push                esi
            //   8b048570be4100       | mov                 eax, dword ptr [eax*4 + 0x41be70]
            //   8b7508               | mov                 esi, dword ptr [ebp + 8]
            //   57                   | push                edi

        $sequence_3 = { 57 8b7d08 e9???????? 8b0f 894dfc 8d048de0c14100 }
            // n = 6, score = 100
            //   57                   | push                edi
            //   8b7d08               | mov                 edi, dword ptr [ebp + 8]
            //   e9????????           |                     
            //   8b0f                 | mov                 ecx, dword ptr [edi]
            //   894dfc               | mov                 dword ptr [ebp - 4], ecx
            //   8d048de0c14100       | lea                 eax, [ecx*4 + 0x41c1e0]

        $sequence_4 = { 8b04bd70be4100 807c182800 7d46 8b750c 807e1400 7507 }
            // n = 6, score = 100
            //   8b04bd70be4100       | mov                 eax, dword ptr [edi*4 + 0x41be70]
            //   807c182800           | cmp                 byte ptr [eax + ebx + 0x28], 0
            //   7d46                 | jge                 0x48
            //   8b750c               | mov                 esi, dword ptr [ebp + 0xc]
            //   807e1400             | cmp                 byte ptr [esi + 0x14], 0
            //   7507                 | jne                 9

        $sequence_5 = { 8945f4 8b4514 40 c745ec0a294000 894df8 8945fc 64a100000000 }
            // n = 7, score = 100
            //   8945f4               | mov                 dword ptr [ebp - 0xc], eax
            //   8b4514               | mov                 eax, dword ptr [ebp + 0x14]
            //   40                   | inc                 eax
            //   c745ec0a294000       | mov                 dword ptr [ebp - 0x14], 0x40290a
            //   894df8               | mov                 dword ptr [ebp - 8], ecx
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   64a100000000         | mov                 eax, dword ptr fs:[0]

        $sequence_6 = { c3 8b55fc 8bc6 8d0c95e0c14100 8701 85c0 }
            // n = 6, score = 100
            //   c3                   | ret                 
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]
            //   8bc6                 | mov                 eax, esi
            //   8d0c95e0c14100       | lea                 ecx, [edx*4 + 0x41c1e0]
            //   8701                 | xchg                dword ptr [ecx], eax
            //   85c0                 | test                eax, eax

        $sequence_7 = { 8d0c95e0c14100 8701 85c0 7407 56 ff15???????? }
            // n = 6, score = 100
            //   8d0c95e0c14100       | lea                 ecx, [edx*4 + 0x41c1e0]
            //   8701                 | xchg                dword ptr [ecx], eax
            //   85c0                 | test                eax, eax
            //   7407                 | je                  9
            //   56                   | push                esi
            //   ff15????????         |                     

        $sequence_8 = { 8b048570be4100 8b4ddc f644012801 7517 8b4514 c6401c01 c7401809000000 }
            // n = 7, score = 100
            //   8b048570be4100       | mov                 eax, dword ptr [eax*4 + 0x41be70]
            //   8b4ddc               | mov                 ecx, dword ptr [ebp - 0x24]
            //   f644012801           | test                byte ptr [ecx + eax + 0x28], 1
            //   7517                 | jne                 0x19
            //   8b4514               | mov                 eax, dword ptr [ebp + 0x14]
            //   c6401c01             | mov                 byte ptr [eax + 0x1c], 1
            //   c7401809000000       | mov                 dword ptr [eax + 0x18], 9

        $sequence_9 = { 8b049d70be4100 f644072801 7444 837c0718ff 743d e8???????? }
            // n = 6, score = 100
            //   8b049d70be4100       | mov                 eax, dword ptr [ebx*4 + 0x41be70]
            //   f644072801           | test                byte ptr [edi + eax + 0x28], 1
            //   7444                 | je                  0x46
            //   837c0718ff           | cmp                 dword ptr [edi + eax + 0x18], -1
            //   743d                 | je                  0x3f
            //   e8????????           |                     

    condition:
        7 of them and filesize < 253952
}