rule win_ntospy_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.ntospy."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.ntospy"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c705????????01000000 c705????????01000000 b808000000 486bc000 488d0d0ead0000 8b542430 48891401 }
            // n = 7, score = 100
            //   c705????????01000000     |     
            //   c705????????01000000     |     
            //   b808000000           | dec                 esp
            //   486bc000             | mov                 ebp, edx
            //   488d0d0ead0000       | dec                 ecx
            //   8b542430             | mov                 eax, dword ptr [edi + edi*8 + 0x15be8]
            //   48891401             | dec                 ecx

        $sequence_1 = { 837a2400 7d04 32c0 eb14 b001 eb10 }
            // n = 6, score = 100
            //   837a2400             | mov                 esi, ecx
            //   7d04                 | dec                 eax
            //   32c0                 | test                ecx, ecx
            //   eb14                 | je                  0xc65
            //   b001                 | xor                 ebx, ebx
            //   eb10                 | dec                 esp

        $sequence_2 = { 488d0585520100 c3 8325????????00 c3 48895c2408 55 488dac2440fbffff }
            // n = 7, score = 100
            //   488d0585520100       | mov                 ebp, dword ptr [esp + 0x48]
            //   c3                   | dec                 eax
            //   8325????????00       |                     
            //   c3                   | mov                 esi, dword ptr [esp + 0x50]
            //   48895c2408           | dec                 eax
            //   55                   | add                 esp, 0x20
            //   488dac2440fbffff     | inc                 ecx

        $sequence_3 = { 4c8bda 488d356780ffff 4183e30f 488bfa 492bfb }
            // n = 5, score = 100
            //   4c8bda               | push                edi
            //   488d356780ffff       | dec                 eax
            //   4183e30f             | sub                 esp, 0x20
            //   488bfa               | mov                 edi, ecx
            //   492bfb               | dec                 esp

        $sequence_4 = { 498784f620600100 eb1e 488bc3 498784f620600100 4885c0 }
            // n = 5, score = 100
            //   498784f620600100     | dec                 eax
            //   eb1e                 | lea                 edx, [0x11a39]
            //   488bc3               | inc                 ebp
            //   498784f620600100     | xor                 eax, eax
            //   4885c0               | dec                 eax

        $sequence_5 = { b91c000000 4c8d0560770000 488d155d770000 e8???????? 4885c0 7416 }
            // n = 6, score = 100
            //   b91c000000           | mov                 ecx, dword ptr [eax + ecx*8]
            //   4c8d0560770000       | dec                 esp
            //   488d155d770000       | lea                 eax, [0xd3cc]
            //   e8????????           |                     
            //   4885c0               | and                 edx, 0x3f
            //   7416                 | dec                 eax

        $sequence_6 = { 740f 833c240c 7410 eb15 }
            // n = 4, score = 100
            //   740f                 | lea                 edx, [0x933a]
            //   833c240c             | dec                 eax
            //   7410                 | lea                 ecx, [0x932b]
            //   eb15                 | dec                 eax

        $sequence_7 = { 488b4c2448 ff15???????? 48c744242000000000 4c8d4c2440 41b804000000 }
            // n = 5, score = 100
            //   488b4c2448           | lea                 eax, [0x13743]
            //   ff15????????         |                     
            //   48c744242000000000     | dec    ebx
            //   4c8d4c2440           | jmp                 0x376
            //   41b804000000         | dec                 eax

        $sequence_8 = { 4883ec28 488b442440 4883c028 488b4c2440 4883c118 }
            // n = 5, score = 100
            //   4883ec28             | dec                 eax
            //   488b442440           | lea                 eax, [0x112b2]
            //   4883c028             | dec                 eax
            //   488b4c2440           | cmp                 ecx, eax
            //   4883c118             | je                  0x2f6

        $sequence_9 = { 4c8d2dcaf80000 448bf3 498bc5 8d6b01 3938 }
            // n = 5, score = 100
            //   4c8d2dcaf80000       | dec                 ecx
            //   448bf3               | mov                 ebp, eax
            //   498bc5               | dec                 esp
            //   8d6b01               | mov                 ebp, edx
            //   3938                 | inc                 esp

    condition:
        7 of them and filesize < 208896
}