rule win_nvisospit_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.nvisospit."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.nvisospit"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c6857ff9ffff4b 8b45dc 898580f9ffff 8b45e0 66898584f9ffff c7858af9ffff00000000 }
            // n = 6, score = 100
            //   c6857ff9ffff4b       | mov                 byte ptr [ebp - 0x681], 0x4b
            //   8b45dc               | mov                 eax, dword ptr [ebp - 0x24]
            //   898580f9ffff         | mov                 dword ptr [ebp - 0x680], eax
            //   8b45e0               | mov                 eax, dword ptr [ebp - 0x20]
            //   66898584f9ffff       | mov                 word ptr [ebp - 0x67c], ax
            //   c7858af9ffff00000000     | mov    dword ptr [ebp - 0x676], 0

        $sequence_1 = { 0fb785b4fdffff 0fb7c0 8db5b4fdffff 81c607010000 89742414 8db5b4fdffff 83c606 }
            // n = 7, score = 100
            //   0fb785b4fdffff       | movzx               eax, word ptr [ebp - 0x24c]
            //   0fb7c0               | movzx               eax, ax
            //   8db5b4fdffff         | lea                 esi, [ebp - 0x24c]
            //   81c607010000         | add                 esi, 0x107
            //   89742414             | mov                 dword ptr [esp + 0x14], esi
            //   8db5b4fdffff         | lea                 esi, [ebp - 0x24c]
            //   83c606               | add                 esi, 6

        $sequence_2 = { c70424e8030000 a1???????? ffd0 83ec04 b800000000 8d65f4 59 }
            // n = 7, score = 100
            //   c70424e8030000       | mov                 dword ptr [esp], 0x3e8
            //   a1????????           |                     
            //   ffd0                 | call                eax
            //   83ec04               | sub                 esp, 4
            //   b800000000           | mov                 eax, 0
            //   8d65f4               | lea                 esp, [ebp - 0xc]
            //   59                   | pop                 ecx

        $sequence_3 = { 8d7600 8dbc2700000000 8b06 0fb65e08 8b4e04 8d9000004000 8b8000004000 }
            // n = 7, score = 100
            //   8d7600               | lea                 esi, [esi]
            //   8dbc2700000000       | lea                 edi, [edi]
            //   8b06                 | mov                 eax, dword ptr [esi]
            //   0fb65e08             | movzx               ebx, byte ptr [esi + 8]
            //   8b4e04               | mov                 ecx, dword ptr [esi + 4]
            //   8d9000004000         | lea                 edx, [eax + 0x400000]
            //   8b8000004000         | mov                 eax, dword ptr [eax + 0x400000]

        $sequence_4 = { 83ea01 83fa05 7707 8b0c9598444000 dd4018 }
            // n = 5, score = 100
            //   83ea01               | sub                 edx, 1
            //   83fa05               | cmp                 edx, 5
            //   7707                 | ja                  9
            //   8b0c9598444000       | mov                 ecx, dword ptr [edx*4 + 0x404498]
            //   dd4018               | fld                 qword ptr [eax + 0x18]

        $sequence_5 = { 7408 83e840 83e0bf 7512 8305????????01 83c430 }
            // n = 6, score = 100
            //   7408                 | je                  0xa
            //   83e840               | sub                 eax, 0x40
            //   83e0bf               | and                 eax, 0xffffffbf
            //   7512                 | jne                 0x14
            //   8305????????01       |                     
            //   83c430               | add                 esp, 0x30

        $sequence_6 = { 83c008 8b00 8d95a2f9ffff 89542420 8d95a4f9ffff }
            // n = 5, score = 100
            //   83c008               | add                 eax, 8
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   8d95a2f9ffff         | lea                 edx, [ebp - 0x65e]
            //   89542420             | mov                 dword ptr [esp + 0x20], edx
            //   8d95a4f9ffff         | lea                 edx, [ebp - 0x65c]

        $sequence_7 = { c7442414ffff0000 c744241000000000 8b55d4 8954240c c7442408???????? }
            // n = 5, score = 100
            //   c7442414ffff0000     | mov                 dword ptr [esp + 0x14], 0xffff
            //   c744241000000000     | mov                 dword ptr [esp + 0x10], 0
            //   8b55d4               | mov                 edx, dword ptr [ebp - 0x2c]
            //   8954240c             | mov                 dword ptr [esp + 0xc], edx
            //   c7442408????????     |                     

        $sequence_8 = { e8???????? c7442404ccffffff c70424???????? e8???????? c7442404d1feffff }
            // n = 5, score = 100
            //   e8????????           |                     
            //   c7442404ccffffff     | mov                 dword ptr [esp + 4], 0xffffffcc
            //   c70424????????       |                     
            //   e8????????           |                     
            //   c7442404d1feffff     | mov                 dword ptr [esp + 4], 0xfffffed1

        $sequence_9 = { 8b442428 8d50fc 83e2fb 7408 83e840 }
            // n = 5, score = 100
            //   8b442428             | mov                 eax, dword ptr [esp + 0x28]
            //   8d50fc               | lea                 edx, [eax - 4]
            //   83e2fb               | and                 edx, 0xfffffffb
            //   7408                 | je                  0xa
            //   83e840               | sub                 eax, 0x40

    condition:
        7 of them and filesize < 66560
}