rule win_nymaim2_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.nymaim2."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.nymaim2"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8065fc00 8d4dd8 e8???????? 834dfcff 8d4d08 e8???????? 8b4df4 }
            // n = 7, score = 200
            //   8065fc00             | and                 byte ptr [ebp - 4], 0
            //   8d4dd8               | lea                 ecx, [ebp - 0x28]
            //   e8????????           |                     
            //   834dfcff             | or                  dword ptr [ebp - 4], 0xffffffff
            //   8d4d08               | lea                 ecx, [ebp + 8]
            //   e8????????           |                     
            //   8b4df4               | mov                 ecx, dword ptr [ebp - 0xc]

        $sequence_1 = { 3b01 751e 53 50 8d450c 56 50 }
            // n = 7, score = 200
            //   3b01                 | cmp                 eax, dword ptr [ecx]
            //   751e                 | jne                 0x20
            //   53                   | push                ebx
            //   50                   | push                eax
            //   8d450c               | lea                 eax, [ebp + 0xc]
            //   56                   | push                esi
            //   50                   | push                eax

        $sequence_2 = { 8bcc 896508 50 ff75e4 eb20 a1???????? }
            // n = 6, score = 200
            //   8bcc                 | mov                 ecx, esp
            //   896508               | mov                 dword ptr [ebp + 8], esp
            //   50                   | push                eax
            //   ff75e4               | push                dword ptr [ebp - 0x1c]
            //   eb20                 | jmp                 0x22
            //   a1????????           |                     

        $sequence_3 = { 7e64 8b45b8 8d4dec 8d04b0 50 e8???????? 8d4dec }
            // n = 7, score = 200
            //   7e64                 | jle                 0x66
            //   8b45b8               | mov                 eax, dword ptr [ebp - 0x48]
            //   8d4dec               | lea                 ecx, [ebp - 0x14]
            //   8d04b0               | lea                 eax, [eax + esi*4]
            //   50                   | push                eax
            //   e8????????           |                     
            //   8d4dec               | lea                 ecx, [ebp - 0x14]

        $sequence_4 = { 57 8bf1 8365fc00 8b7e08 51 8d4508 8bcc }
            // n = 7, score = 200
            //   57                   | push                edi
            //   8bf1                 | mov                 esi, ecx
            //   8365fc00             | and                 dword ptr [ebp - 4], 0
            //   8b7e08               | mov                 edi, dword ptr [esi + 8]
            //   51                   | push                ecx
            //   8d4508               | lea                 eax, [ebp + 8]
            //   8bcc                 | mov                 ecx, esp

        $sequence_5 = { 56 50 c645fc03 ff7508 ff75ec e8???????? 83c410 }
            // n = 7, score = 200
            //   56                   | push                esi
            //   50                   | push                eax
            //   c645fc03             | mov                 byte ptr [ebp - 4], 3
            //   ff7508               | push                dword ptr [ebp + 8]
            //   ff75ec               | push                dword ptr [ebp - 0x14]
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10

        $sequence_6 = { 33db 59 53 8d4ddc e8???????? 8d8d30ffffff 895dfc }
            // n = 7, score = 200
            //   33db                 | xor                 ebx, ebx
            //   59                   | pop                 ecx
            //   53                   | push                ebx
            //   8d4ddc               | lea                 ecx, [ebp - 0x24]
            //   e8????????           |                     
            //   8d8d30ffffff         | lea                 ecx, [ebp - 0xd0]
            //   895dfc               | mov                 dword ptr [ebp - 4], ebx

        $sequence_7 = { 03450c c1ea0c 0301 83ea00 }
            // n = 4, score = 200
            //   03450c               | add                 eax, dword ptr [ebp + 0xc]
            //   c1ea0c               | shr                 edx, 0xc
            //   0301                 | add                 eax, dword ptr [ecx]
            //   83ea00               | sub                 edx, 0

        $sequence_8 = { 837dd80c 74e7 3ac3 0f843f030000 837dd802 7509 395dd0 }
            // n = 7, score = 200
            //   837dd80c             | cmp                 dword ptr [ebp - 0x28], 0xc
            //   74e7                 | je                  0xffffffe9
            //   3ac3                 | cmp                 al, bl
            //   0f843f030000         | je                  0x345
            //   837dd802             | cmp                 dword ptr [ebp - 0x28], 2
            //   7509                 | jne                 0xb
            //   395dd0               | cmp                 dword ptr [ebp - 0x30], ebx

        $sequence_9 = { c645fc02 e8???????? 8b00 8bcf 8945e8 8d45e4 50 }
            // n = 7, score = 200
            //   c645fc02             | mov                 byte ptr [ebp - 4], 2
            //   e8????????           |                     
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   8bcf                 | mov                 ecx, edi
            //   8945e8               | mov                 dword ptr [ebp - 0x18], eax
            //   8d45e4               | lea                 eax, [ebp - 0x1c]
            //   50                   | push                eax

    condition:
        7 of them and filesize < 753664
}