rule win_oldbait_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.oldbait."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.oldbait"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 6a00 ff15???????? 85c0 7505 e9???????? 6a00 6880000000 }
            // n = 7, score = 400
            //   6a00                 | push                0
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7505                 | jne                 7
            //   e9????????           |                     
            //   6a00                 | push                0
            //   6880000000           | push                0x80

        $sequence_1 = { 8d70ff 85f6 7626 8b4510 }
            // n = 4, score = 400
            //   8d70ff               | lea                 esi, [eax - 1]
            //   85f6                 | test                esi, esi
            //   7626                 | jbe                 0x28
            //   8b4510               | mov                 eax, dword ptr [ebp + 0x10]

        $sequence_2 = { 8a09 888800b01800 ebda 8b45fc 0531b11800 }
            // n = 5, score = 400
            //   8a09                 | mov                 cl, byte ptr [ecx]
            //   888800b01800         | mov                 byte ptr [eax + 0x18b000], cl
            //   ebda                 | jmp                 0xffffffdc
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   0531b11800           | add                 eax, 0x18b131

        $sequence_3 = { 837d2000 7432 66c7045f0d00 43 66c7045f0a00 }
            // n = 5, score = 400
            //   837d2000             | cmp                 dword ptr [ebp + 0x20], 0
            //   7432                 | je                  0x34
            //   66c7045f0d00         | mov                 word ptr [edi + ebx*2], 0xd
            //   43                   | inc                 ebx
            //   66c7045f0a00         | mov                 word ptr [edi + ebx*2], 0xa

        $sequence_4 = { 57 8b7d08 8d70ff 85f6 }
            // n = 4, score = 400
            //   57                   | push                edi
            //   8b7d08               | mov                 edi, dword ptr [ebp + 8]
            //   8d70ff               | lea                 esi, [eax - 1]
            //   85f6                 | test                esi, esi

        $sequence_5 = { 8945f4 ff35???????? ff75fc ff55f4 5f 5e }
            // n = 6, score = 400
            //   8945f4               | mov                 dword ptr [ebp - 0xc], eax
            //   ff35????????         |                     
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   ff55f4               | call                dword ptr [ebp - 0xc]
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi

        $sequence_6 = { 0145d8 33ff 8d837ff61800 803800 }
            // n = 4, score = 400
            //   0145d8               | add                 dword ptr [ebp - 0x28], eax
            //   33ff                 | xor                 edi, edi
            //   8d837ff61800         | lea                 eax, [ebx + 0x18f67f]
            //   803800               | cmp                 byte ptr [eax], 0

        $sequence_7 = { 8bca 83f101 83e107 d3e8 30043a }
            // n = 5, score = 400
            //   8bca                 | mov                 ecx, edx
            //   83f101               | xor                 ecx, 1
            //   83e107               | and                 ecx, 7
            //   d3e8                 | shr                 eax, cl
            //   30043a               | xor                 byte ptr [edx + edi], al

        $sequence_8 = { 0145d4 41 c1ea04 75dc }
            // n = 4, score = 400
            //   0145d4               | add                 dword ptr [ebp - 0x2c], eax
            //   41                   | inc                 ecx
            //   c1ea04               | shr                 edx, 4
            //   75dc                 | jne                 0xffffffde

        $sequence_9 = { 42 3bd6 894510 72da 8bc7 5f }
            // n = 6, score = 400
            //   42                   | inc                 edx
            //   3bd6                 | cmp                 edx, esi
            //   894510               | mov                 dword ptr [ebp + 0x10], eax
            //   72da                 | jb                  0xffffffdc
            //   8bc7                 | mov                 eax, edi
            //   5f                   | pop                 edi

        $sequence_10 = { 0145d8 8b45d8 3b45c8 7cc2 }
            // n = 4, score = 400
            //   0145d8               | add                 dword ptr [ebp - 0x28], eax
            //   8b45d8               | mov                 eax, dword ptr [ebp - 0x28]
            //   3b45c8               | cmp                 eax, dword ptr [ebp - 0x38]
            //   7cc2                 | jl                  0xffffffc4

        $sequence_11 = { 8bec 8b450c 56 33d2 }
            // n = 4, score = 400
            //   8bec                 | mov                 ebp, esp
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   56                   | push                esi
            //   33d2                 | xor                 edx, edx

        $sequence_12 = { 01459c 8b45c8 8945f8 eb05 }
            // n = 4, score = 400
            //   01459c               | add                 dword ptr [ebp - 0x64], eax
            //   8b45c8               | mov                 eax, dword ptr [ebp - 0x38]
            //   8945f8               | mov                 dword ptr [ebp - 8], eax
            //   eb05                 | jmp                 7

        $sequence_13 = { 0145d8 8b45f0 ff45ec 0fb64004 }
            // n = 4, score = 400
            //   0145d8               | add                 dword ptr [ebp - 0x28], eax
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]
            //   ff45ec               | inc                 dword ptr [ebp - 0x14]
            //   0fb64004             | movzx               eax, byte ptr [eax + 4]

        $sequence_14 = { 0145d8 8bb54cffffff 56 ff55d0 }
            // n = 4, score = 400
            //   0145d8               | add                 dword ptr [ebp - 0x28], eax
            //   8bb54cffffff         | mov                 esi, dword ptr [ebp - 0xb4]
            //   56                   | push                esi
            //   ff55d0               | call                dword ptr [ebp - 0x30]

        $sequence_15 = { 0103 01451c 8b06 8bc8 c1e906 }
            // n = 5, score = 400
            //   0103                 | add                 dword ptr [ebx], eax
            //   01451c               | add                 dword ptr [ebp + 0x1c], eax
            //   8b06                 | mov                 eax, dword ptr [esi]
            //   8bc8                 | mov                 ecx, eax
            //   c1e906               | shr                 ecx, 6

        $sequence_16 = { 57 8945f0 8945f4 894dec 0f8387000000 895514 83651407 }
            // n = 7, score = 100
            //   57                   | push                edi
            //   8945f0               | mov                 dword ptr [ebp - 0x10], eax
            //   8945f4               | mov                 dword ptr [ebp - 0xc], eax
            //   894dec               | mov                 dword ptr [ebp - 0x14], ecx
            //   0f8387000000         | jae                 0x8d
            //   895514               | mov                 dword ptr [ebp + 0x14], edx
            //   83651407             | and                 dword ptr [ebp + 0x14], 7

        $sequence_17 = { f7d9 1bc9 f7d1 234d14 83f908 }
            // n = 5, score = 100
            //   f7d9                 | neg                 ecx
            //   1bc9                 | sbb                 ecx, ecx
            //   f7d1                 | not                 ecx
            //   234d14               | and                 ecx, dword ptr [ebp + 0x14]
            //   83f908               | cmp                 ecx, 8

        $sequence_18 = { a3???????? 8d85c0feffff 68???????? 50 ff55dc 8d8dc0feffff }
            // n = 6, score = 100
            //   a3????????           |                     
            //   8d85c0feffff         | lea                 eax, [ebp - 0x140]
            //   68????????           |                     
            //   50                   | push                eax
            //   ff55dc               | call                dword ptr [ebp - 0x24]
            //   8d8dc0feffff         | lea                 ecx, [ebp - 0x140]

        $sequence_19 = { 8d45f4 50 8d45dc 50 68???????? ff75f8 }
            // n = 6, score = 100
            //   8d45f4               | lea                 eax, [ebp - 0xc]
            //   50                   | push                eax
            //   8d45dc               | lea                 eax, [ebp - 0x24]
            //   50                   | push                eax
            //   68????????           |                     
            //   ff75f8               | push                dword ptr [ebp - 8]

        $sequence_20 = { 8d85bcfdffff 6a01 50 8d85c0feffff 50 68???????? }
            // n = 6, score = 100
            //   8d85bcfdffff         | lea                 eax, [ebp - 0x244]
            //   6a01                 | push                1
            //   50                   | push                eax
            //   8d85c0feffff         | lea                 eax, [ebp - 0x140]
            //   50                   | push                eax
            //   68????????           |                     

        $sequence_21 = { 83e007 0a1c30 0fb64437fe 03c2 }
            // n = 4, score = 100
            //   83e007               | and                 eax, 7
            //   0a1c30               | or                  bl, byte ptr [eax + esi]
            //   0fb64437fe           | movzx               eax, byte ptr [edi + esi - 2]
            //   03c2                 | add                 eax, edx

        $sequence_22 = { ffd6 ffd0 53 ff55e4 90 90 }
            // n = 6, score = 100
            //   ffd6                 | call                esi
            //   ffd0                 | call                eax
            //   53                   | push                ebx
            //   ff55e4               | call                dword ptr [ebp - 0x1c]
            //   90                   | nop                 
            //   90                   | nop                 

        $sequence_23 = { 56 8b7514 3bc1 57 8945f0 8945f4 }
            // n = 6, score = 100
            //   56                   | push                esi
            //   8b7514               | mov                 esi, dword ptr [ebp + 0x14]
            //   3bc1                 | cmp                 eax, ecx
            //   57                   | push                edi
            //   8945f0               | mov                 dword ptr [ebp - 0x10], eax
            //   8945f4               | mov                 dword ptr [ebp - 0xc], eax

    condition:
        7 of them and filesize < 172032
}