rule win_orcarat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.orcarat."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.orcarat"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b9424401d0000 83c9ff 8bfa 33c0 f2ae f7d1 89442410 }
            // n = 7, score = 200
            //   8b9424401d0000       | mov                 edx, dword ptr [esp + 0x1d40]
            //   83c9ff               | or                  ecx, 0xffffffff
            //   8bfa                 | mov                 edi, edx
            //   33c0                 | xor                 eax, eax
            //   f2ae                 | repne scasb         al, byte ptr es:[edi]
            //   f7d1                 | not                 ecx
            //   89442410             | mov                 dword ptr [esp + 0x10], eax

        $sequence_1 = { 03c8 8d148d7ca04000 8bcd 52 }
            // n = 4, score = 200
            //   03c8                 | add                 ecx, eax
            //   8d148d7ca04000       | lea                 edx, [ecx*4 + 0x40a07c]
            //   8bcd                 | mov                 ecx, ebp
            //   52                   | push                edx

        $sequence_2 = { f7d1 2bf9 81c575020000 8bc1 }
            // n = 4, score = 200
            //   f7d1                 | not                 ecx
            //   2bf9                 | sub                 edi, ecx
            //   81c575020000         | add                 ebp, 0x275
            //   8bc1                 | mov                 eax, ecx

        $sequence_3 = { f2ae 8d542410 8d8424385a0000 f7d1 52 50 894c241c }
            // n = 7, score = 200
            //   f2ae                 | repne scasb         al, byte ptr es:[edi]
            //   8d542410             | lea                 edx, [esp + 0x10]
            //   8d8424385a0000       | lea                 eax, [esp + 0x5a38]
            //   f7d1                 | not                 ecx
            //   52                   | push                edx
            //   50                   | push                eax
            //   894c241c             | mov                 dword ptr [esp + 0x1c], ecx

        $sequence_4 = { 50 8d442414 49 50 51 52 53 }
            // n = 7, score = 200
            //   50                   | push                eax
            //   8d442414             | lea                 eax, [esp + 0x14]
            //   49                   | dec                 ecx
            //   50                   | push                eax
            //   51                   | push                ecx
            //   52                   | push                edx
            //   53                   | push                ebx

        $sequence_5 = { 50 894c241c 51 8d4c242c c744241c00080000 51 }
            // n = 6, score = 200
            //   50                   | push                eax
            //   894c241c             | mov                 dword ptr [esp + 0x1c], ecx
            //   51                   | push                ecx
            //   8d4c242c             | lea                 ecx, [esp + 0x2c]
            //   c744241c00080000     | mov                 dword ptr [esp + 0x1c], 0x800
            //   51                   | push                ecx

        $sequence_6 = { 6a0a 52 6aff e8???????? 8d7c2428 83c9ff }
            // n = 6, score = 200
            //   6a0a                 | push                0xa
            //   52                   | push                edx
            //   6aff                 | push                -1
            //   e8????????           |                     
            //   8d7c2428             | lea                 edi, [esp + 0x28]
            //   83c9ff               | or                  ecx, 0xffffffff

        $sequence_7 = { c21800 8b8c242c080000 55 55 }
            // n = 4, score = 200
            //   c21800               | ret                 0x18
            //   8b8c242c080000       | mov                 ecx, dword ptr [esp + 0x82c]
            //   55                   | push                ebp
            //   55                   | push                ebp

        $sequence_8 = { 8d0c2e 50 51 e8???????? 8b54242c 83c418 03d6 }
            // n = 7, score = 200
            //   8d0c2e               | lea                 ecx, [esi + ebp]
            //   50                   | push                eax
            //   51                   | push                ecx
            //   e8????????           |                     
            //   8b54242c             | mov                 edx, dword ptr [esp + 0x2c]
            //   83c418               | add                 esp, 0x18
            //   03d6                 | add                 edx, esi

        $sequence_9 = { 740b 83f801 75dd 396c2410 75d7 bf???????? 83c9ff }
            // n = 7, score = 200
            //   740b                 | je                  0xd
            //   83f801               | cmp                 eax, 1
            //   75dd                 | jne                 0xffffffdf
            //   396c2410             | cmp                 dword ptr [esp + 0x10], ebp
            //   75d7                 | jne                 0xffffffd9
            //   bf????????           |                     
            //   83c9ff               | or                  ecx, 0xffffffff

    condition:
        7 of them and filesize < 114688
}