rule win_orpcbackdoor_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.orpcbackdoor."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.orpcbackdoor"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff503c 89859cfdffff 83bd9cfdffff00 7d48 8b85d4fdffff 8b00 ffb5d4fdffff }
            // n = 7, score = 100
            //   ff503c               | call                dword ptr [eax + 0x3c]
            //   89859cfdffff         | mov                 dword ptr [ebp - 0x264], eax
            //   83bd9cfdffff00       | cmp                 dword ptr [ebp - 0x264], 0
            //   7d48                 | jge                 0x4a
            //   8b85d4fdffff         | mov                 eax, dword ptr [ebp - 0x22c]
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   ffb5d4fdffff         | push                dword ptr [ebp - 0x22c]

        $sequence_1 = { ff15???????? 8985b0feffff 8d85bcfeffff 50 ffb5b8feffff e8???????? 85c0 }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   8985b0feffff         | mov                 dword ptr [ebp - 0x150], eax
            //   8d85bcfeffff         | lea                 eax, [ebp - 0x144]
            //   50                   | push                eax
            //   ffb5b8feffff         | push                dword ptr [ebp - 0x148]
            //   e8????????           |                     
            //   85c0                 | test                eax, eax

        $sequence_2 = { f20f59148590dc0310 660f5834c5a0e40310 660f54c5 f20f5ce8 f20f58fa f20f10d8 f20f59c1 }
            // n = 7, score = 100
            //   f20f59148590dc0310     | mulsd    xmm2, qword ptr [eax*4 + 0x1003dc90]
            //   660f5834c5a0e40310     | addpd    xmm6, xmmword ptr [eax*8 + 0x1003e4a0]
            //   660f54c5             | andpd               xmm0, xmm5
            //   f20f5ce8             | subsd               xmm5, xmm0
            //   f20f58fa             | addsd               xmm7, xmm2
            //   f20f10d8             | movsd               xmm3, xmm0
            //   f20f59c1             | mulsd               xmm0, xmm1

        $sequence_3 = { 8b55fc 89440ae4 c9 c3 55 8bec 83ec0c }
            // n = 7, score = 100
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]
            //   89440ae4             | mov                 dword ptr [edx + ecx - 0x1c], eax
            //   c9                   | leave               
            //   c3                   | ret                 
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   83ec0c               | sub                 esp, 0xc

        $sequence_4 = { 8d85dcf7ffff 50 8d8d20ebffff e8???????? 8d8da7e6ffff e8???????? 50 }
            // n = 7, score = 100
            //   8d85dcf7ffff         | lea                 eax, [ebp - 0x824]
            //   50                   | push                eax
            //   8d8d20ebffff         | lea                 ecx, [ebp - 0x14e0]
            //   e8????????           |                     
            //   8d8da7e6ffff         | lea                 ecx, [ebp - 0x1959]
            //   e8????????           |                     
            //   50                   | push                eax

        $sequence_5 = { 83b8a800000000 750e 8b04bd20cc0610 807c182900 741d 8d45fc 50 }
            // n = 7, score = 100
            //   83b8a800000000       | cmp                 dword ptr [eax + 0xa8], 0
            //   750e                 | jne                 0x10
            //   8b04bd20cc0610       | mov                 eax, dword ptr [edi*4 + 0x1006cc20]
            //   807c182900           | cmp                 byte ptr [eax + ebx + 0x29], 0
            //   741d                 | je                  0x1f
            //   8d45fc               | lea                 eax, [ebp - 4]
            //   50                   | push                eax

        $sequence_6 = { c3 85c0 78f5 8b1cc554a30310 6a55 53 e8???????? }
            // n = 7, score = 100
            //   c3                   | ret                 
            //   85c0                 | test                eax, eax
            //   78f5                 | js                  0xfffffff7
            //   8b1cc554a30310       | mov                 ebx, dword ptr [eax*8 + 0x1003a354]
            //   6a55                 | push                0x55
            //   53                   | push                ebx
            //   e8????????           |                     

        $sequence_7 = { 8b4508 8945f4 c645f801 8b45f0 83c004 50 }
            // n = 6, score = 100
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8945f4               | mov                 dword ptr [ebp - 0xc], eax
            //   c645f801             | mov                 byte ptr [ebp - 8], 1
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]
            //   83c004               | add                 eax, 4
            //   50                   | push                eax

        $sequence_8 = { 8b45fc 83c004 50 e8???????? 59 c9 c3 }
            // n = 7, score = 100
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   83c004               | add                 eax, 4
            //   50                   | push                eax
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   c9                   | leave               
            //   c3                   | ret                 

        $sequence_9 = { e8???????? 59 8b45fc 8b4010 40 50 ff75f8 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   8b4010               | mov                 eax, dword ptr [eax + 0x10]
            //   40                   | inc                 eax
            //   50                   | push                eax
            //   ff75f8               | push                dword ptr [ebp - 8]

    condition:
        7 of them and filesize < 918528
}