rule win_outlook_backdoor_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.outlook_backdoor."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.outlook_backdoor"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b450c 83650c00 53 56 0fb730 57 6685f6 }
            // n = 7, score = 600
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   83650c00             | and                 dword ptr [ebp + 0xc], 0
            //   53                   | push                ebx
            //   56                   | push                esi
            //   0fb730               | movzx               esi, word ptr [eax]
            //   57                   | push                edi
            //   6685f6               | test                si, si

        $sequence_1 = { 8bf9 33f6 8bda 3bfe 740c 57 e8???????? }
            // n = 7, score = 600
            //   8bf9                 | mov                 edi, ecx
            //   33f6                 | xor                 esi, esi
            //   8bda                 | mov                 ebx, edx
            //   3bfe                 | cmp                 edi, esi
            //   740c                 | je                  0xe
            //   57                   | push                edi
            //   e8????????           |                     

        $sequence_2 = { e8???????? 8b450c 8945f0 3bc3 7473 eb03 }
            // n = 6, score = 600
            //   e8????????           |                     
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   8945f0               | mov                 dword ptr [ebp - 0x10], eax
            //   3bc3                 | cmp                 eax, ebx
            //   7473                 | je                  0x75
            //   eb03                 | jmp                 5

        $sequence_3 = { 51 ff7608 8945f0 8d8528ffffff 50 e8???????? 59 }
            // n = 7, score = 600
            //   51                   | push                ecx
            //   ff7608               | push                dword ptr [esi + 8]
            //   8945f0               | mov                 dword ptr [ebp - 0x10], eax
            //   8d8528ffffff         | lea                 eax, [ebp - 0xd8]
            //   50                   | push                eax
            //   e8????????           |                     
            //   59                   | pop                 ecx

        $sequence_4 = { e8???????? 51 56 8b7508 8365fc00 e8???????? }
            // n = 6, score = 600
            //   e8????????           |                     
            //   51                   | push                ecx
            //   56                   | push                esi
            //   8b7508               | mov                 esi, dword ptr [ebp + 8]
            //   8365fc00             | and                 dword ptr [ebp - 4], 0
            //   e8????????           |                     

        $sequence_5 = { 59 8b450c 8b5508 57 ff75f0 8bcb e8???????? }
            // n = 7, score = 600
            //   59                   | pop                 ecx
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]
            //   57                   | push                edi
            //   ff75f0               | push                dword ptr [ebp - 0x10]
            //   8bcb                 | mov                 ecx, ebx
            //   e8????????           |                     

        $sequence_6 = { eb02 33c0 8bf0 ff75f0 ff15???????? 5f 8bc6 }
            // n = 7, score = 600
            //   eb02                 | jmp                 4
            //   33c0                 | xor                 eax, eax
            //   8bf0                 | mov                 esi, eax
            //   ff75f0               | push                dword ptr [ebp - 0x10]
            //   ff15????????         |                     
            //   5f                   | pop                 edi
            //   8bc6                 | mov                 eax, esi

        $sequence_7 = { 81c338070000 e8???????? 33ff 57 6a01 8d7500 }
            // n = 6, score = 600
            //   81c338070000         | add                 ebx, 0x738
            //   e8????????           |                     
            //   33ff                 | xor                 edi, edi
            //   57                   | push                edi
            //   6a01                 | push                1
            //   8d7500               | lea                 esi, [ebp]

        $sequence_8 = { 03ce 034d08 2bc6 2b4514 }
            // n = 4, score = 600
            //   03ce                 | add                 ecx, esi
            //   034d08               | add                 ecx, dword ptr [ebp + 8]
            //   2bc6                 | sub                 eax, esi
            //   2b4514               | sub                 eax, dword ptr [ebp + 0x14]

        $sequence_9 = { 57 8b7d10 8945e8 8b4518 895de0 897de4 8945ec }
            // n = 7, score = 600
            //   57                   | push                edi
            //   8b7d10               | mov                 edi, dword ptr [ebp + 0x10]
            //   8945e8               | mov                 dword ptr [ebp - 0x18], eax
            //   8b4518               | mov                 eax, dword ptr [ebp + 0x18]
            //   895de0               | mov                 dword ptr [ebp - 0x20], ebx
            //   897de4               | mov                 dword ptr [ebp - 0x1c], edi
            //   8945ec               | mov                 dword ptr [ebp - 0x14], eax

    condition:
        7 of them and filesize < 2912256
}