rule win_padcrypt_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2020-10-14"
        version = "1"
        description = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.5.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.padcrypt"
        malpedia_rule_date = "20201014"
        malpedia_hash = "a7e3bd57eaf12bf3ea29a863c041091ba3af9ac9"
        malpedia_version = "20201014"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 5e 4d 3465 f7b4765cd8185c }
            // n = 4, score = 300
            //   5e                   | pop                 esi
            //   4d                   | dec                 ebp
            //   3465                 | xor                 al, 0x65
            //   f7b4765cd8185c       | div                 dword ptr [esi + esi*2 + 0x5c18d85c]

        $sequence_1 = { 7720 327186 56 6d }
            // n = 4, score = 300
            //   7720                 | ja                  0x22
            //   327186               | xor                 dh, byte ptr [ecx - 0x7a]
            //   56                   | push                esi
            //   6d                   | insd                dword ptr es:[edi], dx

        $sequence_2 = { 43 51 81126851fc92 5f ec }
            // n = 5, score = 300
            //   43                   | inc                 ebx
            //   51                   | push                ecx
            //   81126851fc92         | adc                 dword ptr [edx], 0x92fc5168
            //   5f                   | pop                 edi
            //   ec                   | in                  al, dx

        $sequence_3 = { 1b8991d77252 1a992dc51053 2ea873 57 }
            // n = 4, score = 300
            //   1b8991d77252         | sbb                 ecx, dword ptr [ecx + 0x5272d791]
            //   1a992dc51053         | sbb                 bl, byte ptr [ecx + 0x5310c52d]
            //   2ea873               | test                al, 0x73
            //   57                   | push                edi

        $sequence_4 = { a5 e437 1a826bac357c 1b02 5b }
            // n = 5, score = 300
            //   a5                   | movsd               dword ptr es:[edi], dword ptr [esi]
            //   e437                 | in                  al, 0x37
            //   1a826bac357c         | sbb                 al, byte ptr [edx + 0x7c35ac6b]
            //   1b02                 | sbb                 eax, dword ptr [edx]
            //   5b                   | pop                 ebx

        $sequence_5 = { 90 41 1b8991d77252 1a992dc51053 2ea873 57 }
            // n = 6, score = 300
            //   90                   | nop                 
            //   41                   | inc                 ecx
            //   1b8991d77252         | sbb                 ecx, dword ptr [ecx + 0x5272d791]
            //   1a992dc51053         | sbb                 bl, byte ptr [ecx + 0x5310c52d]
            //   2ea873               | test                al, 0x73
            //   57                   | push                edi

        $sequence_6 = { 5e 4d 3465 f7b4765cd8185c 06 55 6c }
            // n = 7, score = 300
            //   5e                   | pop                 esi
            //   4d                   | dec                 ebp
            //   3465                 | xor                 al, 0x65
            //   f7b4765cd8185c       | div                 dword ptr [esi + esi*2 + 0x5c18d85c]
            //   06                   | push                es
            //   55                   | push                ebp
            //   6c                   | insb                byte ptr es:[edi], dx

        $sequence_7 = { f7b4765cd8185c 06 55 6c 081a 81004662c431 }
            // n = 6, score = 300
            //   f7b4765cd8185c       | div                 dword ptr [esi + esi*2 + 0x5c18d85c]
            //   06                   | push                es
            //   55                   | push                ebp
            //   6c                   | insb                byte ptr es:[edi], dx
            //   081a                 | or                  byte ptr [edx], bl
            //   81004662c431         | add                 dword ptr [eax], 0x31c46246

        $sequence_8 = { c588d09168a2 07 1d61f06890 54 }
            // n = 4, score = 300
            //   c588d09168a2         | lds                 ecx, ptr [eax - 0x5d976e30]
            //   07                   | pop                 es
            //   1d61f06890           | sbb                 eax, 0x9068f061
            //   54                   | push                esp

        $sequence_9 = { 24e1 2945e4 801eb1 0997f06452d6 5e }
            // n = 5, score = 300
            //   24e1                 | and                 al, 0xe1
            //   2945e4               | sub                 dword ptr [ebp - 0x1c], eax
            //   801eb1               | sbb                 byte ptr [esi], 0xb1
            //   0997f06452d6         | or                  dword ptr [edi - 0x29ad9b10], edx
            //   5e                   | pop                 esi

    condition:
        7 of them and filesize < 1892352
}