rule win_paladin_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.paladin."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.paladin"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 83c8ff 8b8c24e4010000 64890d00000000 81c4f0010000 c20400 8d4c2400 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   83c8ff               | or                  eax, 0xffffffff
            //   8b8c24e4010000       | mov                 ecx, dword ptr [esp + 0x1e4]
            //   64890d00000000       | mov                 dword ptr fs:[0], ecx
            //   81c4f0010000         | add                 esp, 0x1f0
            //   c20400               | ret                 4
            //   8d4c2400             | lea                 ecx, [esp]

        $sequence_1 = { eb37 8bce e8???????? 5e c20800 e8???????? 5e }
            // n = 7, score = 200
            //   eb37                 | jmp                 0x39
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     
            //   5e                   | pop                 esi
            //   c20800               | ret                 8
            //   e8????????           |                     
            //   5e                   | pop                 esi

        $sequence_2 = { 83f81a 8944241c 0f8cb6feffff 56 ff15???????? 8b4c2434 8d8424a4020000 }
            // n = 7, score = 200
            //   83f81a               | cmp                 eax, 0x1a
            //   8944241c             | mov                 dword ptr [esp + 0x1c], eax
            //   0f8cb6feffff         | jl                  0xfffffebc
            //   56                   | push                esi
            //   ff15????????         |                     
            //   8b4c2434             | mov                 ecx, dword ptr [esp + 0x34]
            //   8d8424a4020000       | lea                 eax, [esp + 0x2a4]

        $sequence_3 = { eb0c c744241430a80010 8b7c2414 8b2d???????? }
            // n = 4, score = 200
            //   eb0c                 | jmp                 0xe
            //   c744241430a80010     | mov                 dword ptr [esp + 0x14], 0x1000a830
            //   8b7c2414             | mov                 edi, dword ptr [esp + 0x14]
            //   8b2d????????         |                     

        $sequence_4 = { 8d0417 8d0440 8d0480 c1e002 3bf0 7344 833d????????01 }
            // n = 7, score = 200
            //   8d0417               | lea                 eax, [edi + edx]
            //   8d0440               | lea                 eax, [eax + eax*2]
            //   8d0480               | lea                 eax, [eax + eax*4]
            //   c1e002               | shl                 eax, 2
            //   3bf0                 | cmp                 esi, eax
            //   7344                 | jae                 0x46
            //   833d????????01       |                     

        $sequence_5 = { ffd7 8b4e18 3bcb 7406 8b11 6a01 ff12 }
            // n = 7, score = 200
            //   ffd7                 | call                edi
            //   8b4e18               | mov                 ecx, dword ptr [esi + 0x18]
            //   3bcb                 | cmp                 ecx, ebx
            //   7406                 | je                  8
            //   8b11                 | mov                 edx, dword ptr [ecx]
            //   6a01                 | push                1
            //   ff12                 | call                dword ptr [edx]

        $sequence_6 = { 50 52 ff15???????? e9???????? 3d05010000 7417 }
            // n = 6, score = 200
            //   50                   | push                eax
            //   52                   | push                edx
            //   ff15????????         |                     
            //   e9????????           |                     
            //   3d05010000           | cmp                 eax, 0x105
            //   7417                 | je                  0x19

        $sequence_7 = { 8b4604 8d4e08 894204 e8???????? 56 e8???????? 8b4f14 }
            // n = 7, score = 200
            //   8b4604               | mov                 eax, dword ptr [esi + 4]
            //   8d4e08               | lea                 ecx, [esi + 8]
            //   894204               | mov                 dword ptr [edx + 4], eax
            //   e8????????           |                     
            //   56                   | push                esi
            //   e8????????           |                     
            //   8b4f14               | mov                 ecx, dword ptr [edi + 0x14]

        $sequence_8 = { 6a00 52 ff15???????? 8b4624 8b4c2410 2bc3 8b6e58 }
            // n = 7, score = 200
            //   6a00                 | push                0
            //   52                   | push                edx
            //   ff15????????         |                     
            //   8b4624               | mov                 eax, dword ptr [esi + 0x24]
            //   8b4c2410             | mov                 ecx, dword ptr [esp + 0x10]
            //   2bc3                 | sub                 eax, ebx
            //   8b6e58               | mov                 ebp, dword ptr [esi + 0x58]

        $sequence_9 = { 85f6 897c2428 0f8490000000 85ff 0f8488000000 55 }
            // n = 6, score = 200
            //   85f6                 | test                esi, esi
            //   897c2428             | mov                 dword ptr [esp + 0x28], edi
            //   0f8490000000         | je                  0x96
            //   85ff                 | test                edi, edi
            //   0f8488000000         | je                  0x8e
            //   55                   | push                ebp

    condition:
        7 of them and filesize < 106496
}