rule win_pebbledash_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.pebbledash."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.pebbledash"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 50 b9???????? e8???????? 85c0 7507 }
            // n = 5, score = 500
            //   50                   | push                eax
            //   b9????????           |                     
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   7507                 | jne                 9

        $sequence_1 = { 5e c3 55 8b6c2408 56 33f6 8b4d00 }
            // n = 7, score = 500
            //   5e                   | pop                 esi
            //   c3                   | ret                 
            //   55                   | push                ebp
            //   8b6c2408             | mov                 ebp, dword ptr [esp + 8]
            //   56                   | push                esi
            //   33f6                 | xor                 esi, esi
            //   8b4d00               | mov                 ecx, dword ptr [ebp]

        $sequence_2 = { e8???????? 33d2 b90e000000 f7f1 }
            // n = 4, score = 500
            //   e8????????           |                     
            //   33d2                 | xor                 edx, edx
            //   b90e000000           | mov                 ecx, 0xe
            //   f7f1                 | div                 ecx

        $sequence_3 = { 6829080000 68???????? 68???????? e8???????? 83c40c }
            // n = 5, score = 500
            //   6829080000           | push                0x829
            //   68????????           |                     
            //   68????????           |                     
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc

        $sequence_4 = { 832000 a1???????? a3???????? c3 8b442404 a3???????? c3 }
            // n = 7, score = 500
            //   832000               | and                 dword ptr [eax], 0
            //   a1????????           |                     
            //   a3????????           |                     
            //   c3                   | ret                 
            //   8b442404             | mov                 eax, dword ptr [esp + 4]
            //   a3????????           |                     
            //   c3                   | ret                 

        $sequence_5 = { 894604 5e c3 55 8bec 833d????????00 750f }
            // n = 7, score = 500
            //   894604               | mov                 dword ptr [esi + 4], eax
            //   5e                   | pop                 esi
            //   c3                   | ret                 
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   833d????????00       |                     
            //   750f                 | jne                 0x11

        $sequence_6 = { 8bc1 5b 5e 5f c9 c3 6a01 }
            // n = 7, score = 500
            //   8bc1                 | mov                 eax, ecx
            //   5b                   | pop                 ebx
            //   5e                   | pop                 esi
            //   5f                   | pop                 edi
            //   c9                   | leave               
            //   c3                   | ret                 
            //   6a01                 | push                1

        $sequence_7 = { e8???????? 6888130000 ff15???????? b9???????? e8???????? 68???????? e8???????? }
            // n = 7, score = 500
            //   e8????????           |                     
            //   6888130000           | push                0x1388
            //   ff15????????         |                     
            //   b9????????           |                     
            //   e8????????           |                     
            //   68????????           |                     
            //   e8????????           |                     

        $sequence_8 = { 8905???????? 0fb64201 440bc0 0fb64202 41c1e008 440bc0 }
            // n = 6, score = 200
            //   8905????????         |                     
            //   0fb64201             | movzx               eax, byte ptr [edx + 9]
            //   440bc0               | movzx               ecx, byte ptr [edx + 8]
            //   0fb64202             | inc                 ebp
            //   41c1e008             | inc                 ecx
            //   440bc0               | mov                 ecx, edx

        $sequence_9 = { e8???????? 488d542440 488bce ffd0 }
            // n = 4, score = 200
            //   e8????????           |                     
            //   488d542440           | mov                 edi, dword ptr [esp + 0x40]
            //   488bce               | inc                 ecx
            //   ffd0                 | mov                 dword ptr [ebx], ecx

        $sequence_10 = { 0bc8 0fb6420b c1e108 0bc8 41894e08 }
            // n = 5, score = 200
            //   0bc8                 | mov                 ecx, edx
            //   0fb6420b             | mov                 ecx, dword ptr [eax - 0x18]
            //   c1e108               | inc                 ecx
            //   0bc8                 | mov                 dword ptr [ebx + 8], ecx
            //   41894e08             | mov                 ecx, dword ptr [eax - 0x14]

        $sequence_11 = { 66420f6e4ccb10 4b8d0c5b 660f6e5ccb10 4183c308 4c8d0440 66420f6e54c310 8d47ff }
            // n = 7, score = 200
            //   66420f6e4ccb10       | movzx               eax, byte ptr [edx + 1]
            //   4b8d0c5b             | dec                 esp
            //   660f6e5ccb10         | lea                 esi, [ecx + 0x100]
            //   4183c308             | movzx               edi, byte ptr [edx]
            //   4c8d0440             | dec                 esp
            //   66420f6e54c310       | lea                 esp, [0xffffda8f]
            //   8d47ff               | inc                 esp

        $sequence_12 = { 3008 488d4001 4883ea01 75f0 eb0c }
            // n = 5, score = 200
            //   3008                 | inc                 ecx
            //   488d4001             | mov                 dword ptr [ebx + 0xc], ecx
            //   4883ea01             | inc                 ecx
            //   75f0                 | pop                 edi
            //   eb0c                 | dec                 ecx

        $sequence_13 = { 0bc8 0fb6420f c1e108 0bc8 41894e0c }
            // n = 5, score = 200
            //   0bc8                 | inc                 ebp
            //   0fb6420f             | mov                 eax, edx
            //   c1e108               | shr                 ecx, 0x10
            //   0bc8                 | movzx               edx, cl
            //   41894e0c             | inc                 ecx

        $sequence_14 = { 498bcc 85c0 7512 e8???????? }
            // n = 4, score = 200
            //   498bcc               | add                 ebx, 8
            //   85c0                 | dec                 esp
            //   7512                 | lea                 eax, [eax + eax*2]
            //   e8????????           |                     

        $sequence_15 = { 41c1e008 8905???????? 0fb64201 440bc0 }
            // n = 4, score = 200
            //   41c1e008             | lea                 ecx, [ebx + ebx*2]
            //   8905????????         |                     
            //   0fb64201             | movd                xmm3, dword ptr [ebx + ecx*8 + 0x10]
            //   440bc0               | inc                 ecx

    condition:
        7 of them and filesize < 677888
}