rule win_pinchduke_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.pinchduke."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.pinchduke"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b702c 8bfe c1cf08 23fa c1c608 23f1 0bfe }
            // n = 7, score = 100
            //   8b702c               | mov                 esi, dword ptr [eax + 0x2c]
            //   8bfe                 | mov                 edi, esi
            //   c1cf08               | ror                 edi, 8
            //   23fa                 | and                 edi, edx
            //   c1c608               | rol                 esi, 8
            //   23f1                 | and                 esi, ecx
            //   0bfe                 | or                  edi, esi

        $sequence_1 = { 7d06 8bc7 f7d8 eb02 8bc7 3bc3 750e }
            // n = 7, score = 100
            //   7d06                 | jge                 8
            //   8bc7                 | mov                 eax, edi
            //   f7d8                 | neg                 eax
            //   eb02                 | jmp                 4
            //   8bc7                 | mov                 eax, edi
            //   3bc3                 | cmp                 eax, ebx
            //   750e                 | jne                 0x10

        $sequence_2 = { c745dc02000000 6810010000 e8???????? 85c0 59 740e ff75f0 }
            // n = 7, score = 100
            //   c745dc02000000       | mov                 dword ptr [ebp - 0x24], 2
            //   6810010000           | push                0x110
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   59                   | pop                 ecx
            //   740e                 | je                  0x10
            //   ff75f0               | push                dword ptr [ebp - 0x10]

        $sequence_3 = { 53 56 57 bf10270000 57 e8???????? 6a04 }
            // n = 7, score = 100
            //   53                   | push                ebx
            //   56                   | push                esi
            //   57                   | push                edi
            //   bf10270000           | mov                 edi, 0x2710
            //   57                   | push                edi
            //   e8????????           |                     
            //   6a04                 | push                4

        $sequence_4 = { 3bc3 59 59 8945f0 0f84ec010000 68???????? 50 }
            // n = 7, score = 100
            //   3bc3                 | cmp                 eax, ebx
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx
            //   8945f0               | mov                 dword ptr [ebp - 0x10], eax
            //   0f84ec010000         | je                  0x1f2
            //   68????????           |                     
            //   50                   | push                eax

        $sequence_5 = { 6a09 33ff 57 68???????? 6801000080 ffd3 85c0 }
            // n = 7, score = 100
            //   6a09                 | push                9
            //   33ff                 | xor                 edi, edi
            //   57                   | push                edi
            //   68????????           |                     
            //   6801000080           | push                0x80000001
            //   ffd3                 | call                ebx
            //   85c0                 | test                eax, eax

        $sequence_6 = { 57 50 6a00 8944241c ffd3 50 ffd5 }
            // n = 7, score = 100
            //   57                   | push                edi
            //   50                   | push                eax
            //   6a00                 | push                0
            //   8944241c             | mov                 dword ptr [esp + 0x1c], eax
            //   ffd3                 | call                ebx
            //   50                   | push                eax
            //   ffd5                 | call                ebp

        $sequence_7 = { 334804 035dfc 33483c 8bfa 33481c c1c705 8975f4 }
            // n = 7, score = 100
            //   334804               | xor                 ecx, dword ptr [eax + 4]
            //   035dfc               | add                 ebx, dword ptr [ebp - 4]
            //   33483c               | xor                 ecx, dword ptr [eax + 0x3c]
            //   8bfa                 | mov                 edi, edx
            //   33481c               | xor                 ecx, dword ptr [eax + 0x1c]
            //   c1c705               | rol                 edi, 5
            //   8975f4               | mov                 dword ptr [ebp - 0xc], esi

        $sequence_8 = { 334828 8bfe 334808 c1c705 33481c c14df002 8d943bdcbc1b8f }
            // n = 7, score = 100
            //   334828               | xor                 ecx, dword ptr [eax + 0x28]
            //   8bfe                 | mov                 edi, esi
            //   334808               | xor                 ecx, dword ptr [eax + 8]
            //   c1c705               | rol                 edi, 5
            //   33481c               | xor                 ecx, dword ptr [eax + 0x1c]
            //   c14df002             | ror                 dword ptr [ebp - 0x10], 2
            //   8d943bdcbc1b8f       | lea                 edx, [ebx + edi - 0x70e44324]

        $sequence_9 = { e8???????? 8d4dcc e8???????? 8d45f0 50 68???????? 6802000080 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8d4dcc               | lea                 ecx, [ebp - 0x34]
            //   e8????????           |                     
            //   8d45f0               | lea                 eax, [ebp - 0x10]
            //   50                   | push                eax
            //   68????????           |                     
            //   6802000080           | push                0x80000002

    condition:
        7 of them and filesize < 223680
}