rule win_pipcreat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.pipcreat."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.pipcreat"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 85c0 75cb 8bc6 53 6bc02c c784055ceeffffffff0000 }
            // n = 6, score = 100
            //   85c0                 | test                eax, eax
            //   75cb                 | jne                 0xffffffcd
            //   8bc6                 | mov                 eax, esi
            //   53                   | push                ebx
            //   6bc02c               | imul                eax, eax, 0x2c
            //   c784055ceeffffffff0000     | mov    dword ptr [ebp + eax - 0x11a4], 0xffff

        $sequence_1 = { ebd8 6a01 ffd6 33db bfc4400010 be10480010 }
            // n = 6, score = 100
            //   ebd8                 | jmp                 0xffffffda
            //   6a01                 | push                1
            //   ffd6                 | call                esi
            //   33db                 | xor                 ebx, ebx
            //   bfc4400010           | mov                 edi, 0x100040c4
            //   be10480010           | mov                 esi, 0x10004810

        $sequence_2 = { 668915???????? ffd6 68???????? 68???????? ffd6 68???????? e8???????? }
            // n = 7, score = 100
            //   668915????????       |                     
            //   ffd6                 | call                esi
            //   68????????           |                     
            //   68????????           |                     
            //   ffd6                 | call                esi
            //   68????????           |                     
            //   e8????????           |                     

        $sequence_3 = { 50 8d8528feffff 6aff 50 53 53 }
            // n = 6, score = 100
            //   50                   | push                eax
            //   8d8528feffff         | lea                 eax, [ebp - 0x1d8]
            //   6aff                 | push                -1
            //   50                   | push                eax
            //   53                   | push                ebx
            //   53                   | push                ebx

        $sequence_4 = { 5e 81c4140a0000 c3 668b0d???????? }
            // n = 4, score = 100
            //   5e                   | pop                 esi
            //   81c4140a0000         | add                 esp, 0xa14
            //   c3                   | ret                 
            //   668b0d????????       |                     

        $sequence_5 = { ff15???????? 8b35???????? 68???????? 68???????? ffd6 668b4c2410 668b15???????? }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   8b35????????         |                     
            //   68????????           |                     
            //   68????????           |                     
            //   ffd6                 | call                esi
            //   668b4c2410           | mov                 cx, word ptr [esp + 0x10]
            //   668b15????????       |                     

        $sequence_6 = { 8945f8 7f14 68e8030000 ffd6 ff4dfc 395dfc 7fd4 }
            // n = 7, score = 100
            //   8945f8               | mov                 dword ptr [ebp - 8], eax
            //   7f14                 | jg                  0x16
            //   68e8030000           | push                0x3e8
            //   ffd6                 | call                esi
            //   ff4dfc               | dec                 dword ptr [ebp - 4]
            //   395dfc               | cmp                 dword ptr [ebp - 4], ebx
            //   7fd4                 | jg                  0xffffffd6

        $sequence_7 = { 33db 57 8d85f8efffff 53 50 }
            // n = 5, score = 100
            //   33db                 | xor                 ebx, ebx
            //   57                   | push                edi
            //   8d85f8efffff         | lea                 eax, [ebp - 0x1008]
            //   53                   | push                ebx
            //   50                   | push                eax

        $sequence_8 = { 66899d28ffffff f3ab 66ab 8d8528feffff }
            // n = 4, score = 100
            //   66899d28ffffff       | mov                 word ptr [ebp - 0xd8], bx
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   66ab                 | stosw               word ptr es:[edi], ax
            //   8d8528feffff         | lea                 eax, [ebp - 0x1d8]

        $sequence_9 = { 6a00 8b0d???????? 6a00 8d442420 6a00 }
            // n = 5, score = 100
            //   6a00                 | push                0
            //   8b0d????????         |                     
            //   6a00                 | push                0
            //   8d442420             | lea                 eax, [esp + 0x20]
            //   6a00                 | push                0

    condition:
        7 of them and filesize < 65536
}