rule win_pirpi_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.pirpi."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.pirpi"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 894504 e9???????? 8b4c2414 8d442424 50 51 e8???????? }
            // n = 7, score = 200
            //   894504               | mov                 dword ptr [ebp + 4], eax
            //   e9????????           |                     
            //   8b4c2414             | mov                 ecx, dword ptr [esp + 0x14]
            //   8d442424             | lea                 eax, [esp + 0x24]
            //   50                   | push                eax
            //   51                   | push                ecx
            //   e8????????           |                     

        $sequence_1 = { c7470402000000 c744241000000000 8b442414 85c0 7407 50 ff15???????? }
            // n = 7, score = 200
            //   c7470402000000       | mov                 dword ptr [edi + 4], 2
            //   c744241000000000     | mov                 dword ptr [esp + 0x10], 0
            //   8b442414             | mov                 eax, dword ptr [esp + 0x14]
            //   85c0                 | test                eax, eax
            //   7407                 | je                  9
            //   50                   | push                eax
            //   ff15????????         |                     

        $sequence_2 = { ff15???????? 6a01 8d4c244c c68424e400000002 ff15???????? 8b44243c 3bc6 }
            // n = 7, score = 200
            //   ff15????????         |                     
            //   6a01                 | push                1
            //   8d4c244c             | lea                 ecx, [esp + 0x4c]
            //   c68424e400000002     | mov                 byte ptr [esp + 0xe4], 2
            //   ff15????????         |                     
            //   8b44243c             | mov                 eax, dword ptr [esp + 0x3c]
            //   3bc6                 | cmp                 eax, esi

        $sequence_3 = { f7d1 c1e207 49 8d7c0220 8bd1 c1e902 f3a5 }
            // n = 7, score = 200
            //   f7d1                 | not                 ecx
            //   c1e207               | shl                 edx, 7
            //   49                   | dec                 ecx
            //   8d7c0220             | lea                 edi, [edx + eax + 0x20]
            //   8bd1                 | mov                 edx, ecx
            //   c1e902               | shr                 ecx, 2
            //   f3a5                 | rep movsd           dword ptr es:[edi], dword ptr [esi]

        $sequence_4 = { 81c444010000 c3 8b842454010000 85c0 7406 c70000000000 }
            // n = 6, score = 200
            //   81c444010000         | add                 esp, 0x144
            //   c3                   | ret                 
            //   8b842454010000       | mov                 eax, dword ptr [esp + 0x154]
            //   85c0                 | test                eax, eax
            //   7406                 | je                  8
            //   c70000000000         | mov                 dword ptr [eax], 0

        $sequence_5 = { 5b 81c400010000 c20400 33c9 83f804 0f95c1 49 }
            // n = 7, score = 200
            //   5b                   | pop                 ebx
            //   81c400010000         | add                 esp, 0x100
            //   c20400               | ret                 4
            //   33c9                 | xor                 ecx, ecx
            //   83f804               | cmp                 eax, 4
            //   0f95c1               | setne               cl
            //   49                   | dec                 ecx

        $sequence_6 = { 56 50 ffd3 25ff000000 8bcf 50 }
            // n = 6, score = 200
            //   56                   | push                esi
            //   50                   | push                eax
            //   ffd3                 | call                ebx
            //   25ff000000           | and                 eax, 0xff
            //   8bcf                 | mov                 ecx, edi
            //   50                   | push                eax

        $sequence_7 = { 8d0c37 83c603 f7e9 8b45f0 8bca c1e91f 03d1 }
            // n = 7, score = 200
            //   8d0c37               | lea                 ecx, [edi + esi]
            //   83c603               | add                 esi, 3
            //   f7e9                 | imul                ecx
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]
            //   8bca                 | mov                 ecx, edx
            //   c1e91f               | shr                 ecx, 0x1f
            //   03d1                 | add                 edx, ecx

        $sequence_8 = { 3bc2 7404 33c2 8901 8b442458 83c104 }
            // n = 6, score = 200
            //   3bc2                 | cmp                 eax, edx
            //   7404                 | je                  6
            //   33c2                 | xor                 eax, edx
            //   8901                 | mov                 dword ptr [ecx], eax
            //   8b442458             | mov                 eax, dword ptr [esp + 0x58]
            //   83c104               | add                 ecx, 4

        $sequence_9 = { 55 50 8bce e8???????? 85c0 0f84ad000000 }
            // n = 6, score = 200
            //   55                   | push                ebp
            //   50                   | push                eax
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   0f84ad000000         | je                  0xb3

    condition:
        7 of them and filesize < 327680
}