rule win_pitou_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.pitou."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.pitou"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 80e703 c0eb05 80e303 80ff00 }
            // n = 4, score = 700
            //   80e703               | mov                 dword ptr [ebp - 6], edx
            //   c0eb05               | movzx               edx, word ptr [eax + 0x14]
            //   80e303               | mov                 word ptr [ebp - 8], dx
            //   80ff00               | mov                 word ptr [ebp - 2], dx

        $sequence_1 = { 8bc2 5e 5a 59 5b }
            // n = 5, score = 700
            //   8bc2                 | inc                 dword ptr [eax + 0x38]
            //   5e                   | mov                 edx, dword ptr [ebx + 0x8280]
            //   5a                   | or                  edx, dword ptr [ebx + 0x8284]
            //   59                   | jne                 0xffffcf58
            //   5b                   | mov                 eax, dword ptr [ebx + 0x8278]

        $sequence_2 = { ac 8bda c1e305 03c3 8bda c1eb02 }
            // n = 6, score = 700
            //   ac                   | jne                 0xffffd3f8
            //   8bda                 | cmp                 eax, ecx
            //   c1e305               | je                  0xffff774e
            //   03c3                 | je                  0x520d
            //   8bda                 | cmp                 eax, ecx
            //   c1eb02               | je                  0x20bd5

        $sequence_3 = { 33c0 ac 8bda c1e305 03c3 8bda }
            // n = 6, score = 700
            //   33c0                 | pop                 es
            //   ac                   | test                eax, 0x54539a16
            //   8bda                 | push                ss
            //   c1e305               | and                 al, 3
            //   03c3                 | push                ebp
            //   8bda                 | pop                 ss

        $sequence_4 = { c1e305 03c3 8bda c1eb02 03c3 }
            // n = 5, score = 700
            //   c1e305               | mov                 ecx, 0x3a0044f9
            //   03c3                 | out                 dx, eax
            //   8bda                 | inc                 ebx
            //   c1eb02               | add                 byte ptr [esi - 0x2dffbd13], cl
            //   03c3                 | push                eax

        $sequence_5 = { 03c3 8bda c1eb02 03c3 }
            // n = 4, score = 700
            //   03c3                 | shr                 eax, 0x1e
            //   8bda                 | imul                eax, eax, 0x7fffffff
            //   c1eb02               | sub                 ecx, eax
            //   03c3                 | add                 eax, edx

        $sequence_6 = { 8a6201 80f457 8acc 80e103 8aec }
            // n = 5, score = 700
            //   8a6201               | inc                 eax
            //   80f457               | mov                 byte ptr [ebx + 0x4c], dh
            //   8acc                 | mov                 dword ptr [ebx + 0x3c], eax
            //   80e103               | mov                 dword ptr [ebx + 0x40], eax
            //   8aec                 | mov                 dword ptr [ebx + 0xa0], eax

        $sequence_7 = { 8a6201 80f457 8acc 80e103 8aec c0ed03 }
            // n = 6, score = 700
            //   8a6201               | mov                 eax, dword ptr [esp + 8]
            //   80f457               | mov                 byte ptr [eax + 0x1c], bl
            //   8acc                 | mov                 ecx, dword ptr [esp + 8]
            //   80e103               | mov                 dword ptr [esp + 0x1c], ecx
            //   8aec                 | mov                 dword ptr [edx + 0xc], ecx
            //   c0ed03               | mov                 eax, dword ptr [ebp - 0x1c]

        $sequence_8 = { 53 80ef18 80ff10 5b }
            // n = 4, score = 700
            //   53                   | dec                 eax
            //   80ef18               | lea                 edx, [ebp + 0x100]
            //   80ff10               | dec                 eax
            //   5b                   | lea                 ecx, [esp + 0x78]

        $sequence_9 = { 8acc 80e103 8aec c0ed03 }
            // n = 4, score = 700
            //   8acc                 | xchg                al, ch
            //   80e103               | sahf                
            //   8aec                 | insb                byte ptr es:[edi], dx
            //   c0ed03               | cli                 

    condition:
        7 of them and filesize < 1106944
}