rule win_poortry_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.poortry."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.poortry"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 55 d3d5 660fbae555 0fbafd34 310424 40fecd 40c0cd6d }
            // n = 7, score = 100
            //   55                   | cmovg               ecx, esi
            //   d3d5                 | xor                 dword ptr [esp], edx
            //   660fbae555           | inc                 ecx
            //   0fbafd34             | xor                 ecx, 0xc0a6d0b
            //   310424               | inc                 ecx
            //   40fecd               | bswap               ecx
            //   40c0cd6d             | inc                 ecx

        $sequence_1 = { 48f7d0 98 80c207 c6c434 6698 0f95c0 d0ca }
            // n = 7, score = 100
            //   48f7d0               | dec                 eax
            //   98                   | mov                 dword ptr [ebp + 8], edx
            //   80c207               | pushfd              
            //   c6c434               | sbb                 cl, 0xd2
            //   6698                 | inc                 sp
            //   0f95c0               | cmp                 ebx, esi
            //   d0ca                 | shr                 ch, cl

        $sequence_2 = { f6c3d5 81f2e415f772 664181f9192e 443aec 4184f8 4152 311424 }
            // n = 7, score = 100
            //   f6c3d5               | sbb                 bp, 0x74d8
            //   81f2e415f772         | cmc                 
            //   664181f9192e         | inc                 ecx
            //   443aec               | ror                 ebx, 2
            //   4184f8               | inc                 ecx
            //   4152                 | push                ecx
            //   311424               | clc                 

        $sequence_3 = { 4032f3 4150 6699 87d2 d2fe 55 40c0f59a }
            // n = 7, score = 100
            //   4032f3               | add                 dl, 0xb4
            //   4150                 | dec                 eax
            //   6699                 | cmovns              ecx, ecx
            //   87d2                 | inc                 ecx
            //   d2fe                 | neg                 dl
            //   55                   | shrd                cx, dx, 0x2c
            //   40c0f59a             | stc                 

        $sequence_4 = { f9 4180fc33 56 313c24 402af1 5e }
            // n = 6, score = 100
            //   f9                   | clc                 
            //   4180fc33             | cmc                 
            //   56                   | neg                 edx
            //   313c24               | not                 edx
            //   402af1               | cmc                 
            //   5e                   | bswap               edx

        $sequence_5 = { f5 f7c7ed4a0055 80fcbc 81f30340226b 4180fef8 f8 81c3793acb71 }
            // n = 7, score = 100
            //   f5                   | dec                 dh
            //   f7c7ed4a0055         | inc                 dl
            //   80fcbc               | inc                 eax
            //   81f30340226b         | dec                 dh
            //   4180fef8             | cmc                 
            //   f8                   | inc                 ecx
            //   81c3793acb71         | xor                 eax, edx

        $sequence_6 = { f5 4181f0a6605c4b 41d1c0 57 4080f71e 4584ee 44310424 }
            // n = 7, score = 100
            //   f5                   | test                dh, 0xd2
            //   4181f0a6605c4b       | inc                 ecx
            //   41d1c0               | push                ecx
            //   57                   | dec                 ecx
            //   4080f71e             | inc                 ecx
            //   4584ee               | xor                 dword ptr [esp], ecx
            //   44310424             | loope               0x17c3

        $sequence_7 = { 6698 fec4 4881f2933d9011 4898 490fbfc4 98 48ffc2 }
            // n = 7, score = 100
            //   6698                 | cmp                 bp, 0x6941
            //   fec4                 | inc                 eax
            //   4881f2933d9011       | test                ch, 0xf1
            //   4898                 | dec                 eax
            //   490fbfc4             | movzx               edx, di
            //   98                   | inc                 sp
            //   48ffc2               | mov                 dword ptr [esi], edx

        $sequence_8 = { 55 f8 4863e8 4c0fa3cd 310c24 6681dd6e1b }
            // n = 6, score = 100
            //   55                   | inc                 ecx
            //   f8                   | xor                 eax, ecx
            //   4863e8               | sub                 eax, 0x5e6964ae
            //   4c0fa3cd             | ror                 eax, 1
            //   310c24               | dec                 ecx
            //   6681dd6e1b           | add                 eax, 4

        $sequence_9 = { d2ef 660fbae309 453ad5 5b f6c68b 4180fa75 f5 }
            // n = 7, score = 100
            //   d2ef                 | cmc                 
            //   660fbae309           | shl                 edx, 0xf8
            //   453ad5               | dec                 ebp
            //   5b                   | xadd                edx, edx
            //   f6c68b               | inc                 esp
            //   4180fa75             | mov                 edx, dword ptr [esi]
            //   f5                   | inc                 ecx

    condition:
        7 of them and filesize < 8078336
}