rule win_postnaptea_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.postnaptea."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.postnaptea"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c74580a1f5a2f5 c74584a3f5a4f5 c74588a5f5a6f5 c7458cd3f5f1f5 c74590f9f5eff5 c7459481f50000 4533c0 }
            // n = 7, score = 100
            //   c74580a1f5a2f5       | sub                 edx, eax
            //   c74584a3f5a4f5       | dec                 eax
            //   c74588a5f5a6f5       | sar                 edx, 1
            //   c7458cd3f5f1f5       | dec                 esp
            //   c74590f9f5eff5       | cmp                 edx, edx
            //   c7459481f50000       | jb                  0x33ae
            //   4533c0               | dec                 eax

        $sequence_1 = { c745841cf506f5 c7458816f519f5 c7458c13f51df5 c7459059f540f5 c745945bf50000 33f6 8bd6 }
            // n = 7, score = 100
            //   c745841cf506f5       | mov                 ecx, edi
            //   c7458816f519f5       | dec                 esp
            //   c7458c13f51df5       | mov                 edi, eax
            //   c7459059f540f5       | dec                 ecx
            //   c745945bf50000       | lea                 eax, [esi + 1]
            //   33f6                 | dec                 eax
            //   8bd6                 | mov                 edx, ebx

        $sequence_2 = { c7853002000013f51bf5 c7853402000043f520f5 c785380200000bf515f5 c7853c02000047f53bf5 c785400200001cf50cf5 c785440200000df505f5 c7854802000015f54ef5 }
            // n = 7, score = 100
            //   c7853002000013f51bf5     | dec    eax
            //   c7853402000043f520f5     | cmove    eax, dword ptr [ebp - 0x61]
            //   c785380200000bf515f5     | mov    dword ptr [eax], esi
            //   c7853c02000047f53bf5     | mov    byte ptr [ebp - 0x55], 0
            //   c785400200001cf50cf5     | movzx    ecx, byte ptr [ebp - 0x54]
            //   c785440200000df505f5     | dec    eax
            //   c7854802000015f54ef5     | lea    eax, [ebp - 0x69]

        $sequence_3 = { c7852009000003f500f5 c785240900001cf506f5 c7852809000055f515f5 c7852c09000018f51cf5 c785300900001cf55af5 c785340900005ef510f5 c7853809000008f574f5 }
            // n = 7, score = 100
            //   c7852009000003f500f5     | dec    ecx
            //   c785240900001cf506f5     | inc    eax
            //   c7852809000055f515f5     | inc    si
            //   c7852c09000018f51cf5     | cmp    dword ptr [eax + eax*2], edi
            //   c785300900001cf55af5     | jne    0x15b1
            //   c785340900005ef510f5     | dec    eax
            //   c7853809000008f574f5     | lea    edx, [ebp + 0x10]

        $sequence_4 = { ff8170040000 83b97004000002 0f8493010000 83cfff 488d2dcb730300 897350 89732c }
            // n = 7, score = 100
            //   ff8170040000         | inc                 edi
            //   83b97004000002       | dec                 eax
            //   0f8493010000         | add                 esi, 0x28
            //   83cfff               | movzx               eax, word ptr [ecx + 6]
            //   488d2dcb730300       | dec                 ecx
            //   897350               | add                 edx, esi
            //   89732c               | mov                 eax, dword ptr [edx + 0x10]

        $sequence_5 = { 498bd4 e8???????? c1e81f 4c8b7c2430 84c0 7430 4c897c2428 }
            // n = 7, score = 100
            //   498bd4               | mov                 eax, dword ptr [ecx + 0x38]
            //   e8????????           |                     
            //   c1e81f               | dec                 esp
            //   4c8b7c2430           | mov                 eax, dword ptr [eax]
            //   84c0                 | dec                 ebp
            //   7430                 | test                eax, eax
            //   4c897c2428           | je                  0xffa

        $sequence_6 = { c7856008000049f54af5 c785640800004bf54cf5 c785680800004df54ef5 c7856c0800004ff550f5 c7857008000051f552f5 c7857408000053f554f5 c7857808000055f556f5 }
            // n = 7, score = 100
            //   c7856008000049f54af5     | sub    eax, eax
            //   c785640800004bf54cf5     | xor    word ptr [ecx], ax
            //   c785680800004df54ef5     | inc    edx
            //   c7856c0800004ff550f5     | cmp    edx, 0x13
            //   c7857008000051f552f5     | dec    eax
            //   c7857408000053f554f5     | lea    ecx, [esp + 0x30]
            //   c7857808000055f556f5     | dec    eax

        $sequence_7 = { c745f001000000 66c745f40001 3a45dc 0f95c3 4c8d4de0 4c8d45c8 488d55b0 }
            // n = 7, score = 100
            //   c745f001000000       | lea                 edx, [0x51034]
            //   66c745f40001         | dec                 eax
            //   3a45dc               | lea                 edx, [0x3ca7a]
            //   0f95c3               | dec                 eax
            //   4c8d4de0             | mov                 ecx, ebx
            //   4c8d45c8             | dec                 eax
            //   488d55b0             | lea                 edx, [0x3ca74]

        $sequence_8 = { c7450455f50000 4533c9 418bd1 41b8a70a0000 0f1f4000 0f1f840000000000 4863c2 }
            // n = 7, score = 100
            //   c7450455f50000       | lea                 edx, [esp + 0x78]
            //   4533c9               | dec                 eax
            //   418bd1               | mov                 ecx, ebx
            //   41b8a70a0000         | dec                 esp
            //   0f1f4000             | mov                 edi, eax
            //   0f1f840000000000     | dec                 eax
            //   4863c2               | mov                 ecx, ebx

        $sequence_9 = { c745a401000000 c74424300af51ff5 c744243409f50af5 c744243814f51df5 c744243c1af53ff5 c74424402ff523f5 c74424442ef521f5 }
            // n = 7, score = 100
            //   c745a401000000       | dec                 eax
            //   c74424300af51ff5     | lea                 eax, [0x522d7]
            //   c744243409f50af5     | mov                 dword ptr [ebx + 0x38], 0xffffffff
            //   c744243814f51df5     | dec                 eax
            //   c744243c1af53ff5     | mov                 dword ptr [ebx], eax
            //   c74424402ff523f5     | dec                 eax
            //   c74424442ef521f5     | lea                 eax, [0x522de]

    condition:
        7 of them and filesize < 2457600
}