rule win_powerduke_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.powerduke."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.powerduke"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 09c0 7434 0345cc 3b4518 0f87f5010000 }
            // n = 5, score = 500
            //   09c0                 | or                  eax, eax
            //   7434                 | je                  0x36
            //   0345cc               | add                 eax, dword ptr [ebp - 0x34]
            //   3b4518               | cmp                 eax, dword ptr [ebp + 0x18]
            //   0f87f5010000         | ja                  0x1fb

        $sequence_1 = { 50 ffb5f8fbffff ff15???????? 58 c9 }
            // n = 5, score = 500
            //   50                   | push                eax
            //   ffb5f8fbffff         | push                dword ptr [ebp - 0x408]
            //   ff15????????         |                     
            //   58                   | pop                 eax
            //   c9                   | leave               

        $sequence_2 = { 56 ff15???????? 09c0 742f 89c7 6a00 }
            // n = 6, score = 500
            //   56                   | push                esi
            //   ff15????????         |                     
            //   09c0                 | or                  eax, eax
            //   742f                 | je                  0x31
            //   89c7                 | mov                 edi, eax
            //   6a00                 | push                0

        $sequence_3 = { 09c0 7518 8d85f8f3ffff 8d8dfcfbffff 51 50 }
            // n = 6, score = 500
            //   09c0                 | or                  eax, eax
            //   7518                 | jne                 0x1a
            //   8d85f8f3ffff         | lea                 eax, [ebp - 0xc08]
            //   8d8dfcfbffff         | lea                 ecx, [ebp - 0x404]
            //   51                   | push                ecx
            //   50                   | push                eax

        $sequence_4 = { 55 89e5 81ec08100000 56 57 8d85f8efffff }
            // n = 6, score = 500
            //   55                   | push                ebp
            //   89e5                 | mov                 ebp, esp
            //   81ec08100000         | sub                 esp, 0x1008
            //   56                   | push                esi
            //   57                   | push                edi
            //   8d85f8efffff         | lea                 eax, [ebp - 0x1008]

        $sequence_5 = { 8b451c c70000000000 837d2000 740f 8b4520 8945dc c745e000000000 }
            // n = 7, score = 500
            //   8b451c               | mov                 eax, dword ptr [ebp + 0x1c]
            //   c70000000000         | mov                 dword ptr [eax], 0
            //   837d2000             | cmp                 dword ptr [ebp + 0x20], 0
            //   740f                 | je                  0x11
            //   8b4520               | mov                 eax, dword ptr [ebp + 0x20]
            //   8945dc               | mov                 dword ptr [ebp - 0x24], eax
            //   c745e000000000       | mov                 dword ptr [ebp - 0x20], 0

        $sequence_6 = { c645e000 c745e177696e68 c745e57474702e 66c745e9646c c645eb6c }
            // n = 5, score = 500
            //   c645e000             | mov                 byte ptr [ebp - 0x20], 0
            //   c745e177696e68       | mov                 dword ptr [ebp - 0x1f], 0x686e6977
            //   c745e57474702e       | mov                 dword ptr [ebp - 0x1b], 0x2e707474
            //   66c745e9646c         | mov                 word ptr [ebp - 0x17], 0x6c64
            //   c645eb6c             | mov                 byte ptr [ebp - 0x15], 0x6c

        $sequence_7 = { 56 57 8d85f8efffff 50 6819000200 6a00 68???????? }
            // n = 7, score = 500
            //   56                   | push                esi
            //   57                   | push                edi
            //   8d85f8efffff         | lea                 eax, [ebp - 0x1008]
            //   50                   | push                eax
            //   6819000200           | push                0x20019
            //   6a00                 | push                0
            //   68????????           |                     

        $sequence_8 = { 8d8df8f3ffff 51 68???????? 50 ff15???????? 83c40c b9???????? }
            // n = 7, score = 500
            //   8d8df8f3ffff         | lea                 ecx, [ebp - 0xc08]
            //   51                   | push                ecx
            //   68????????           |                     
            //   50                   | push                eax
            //   ff15????????         |                     
            //   83c40c               | add                 esp, 0xc
            //   b9????????           |                     

        $sequence_9 = { 8f05???????? c705????????03000000 c745f803000000 ff75dc 8f45f0 ff75e0 8f45f4 }
            // n = 7, score = 500
            //   8f05????????         |                     
            //   c705????????03000000     |     
            //   c745f803000000       | mov                 dword ptr [ebp - 8], 3
            //   ff75dc               | push                dword ptr [ebp - 0x24]
            //   8f45f0               | pop                 dword ptr [ebp - 0x10]
            //   ff75e0               | push                dword ptr [ebp - 0x20]
            //   8f45f4               | pop                 dword ptr [ebp - 0xc]

    condition:
        7 of them and filesize < 57344
}