rule win_powersniff_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.powersniff."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.powersniff"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 754b 68???????? 8d856cfeffff 50 ffd6 }
            // n = 5, score = 100
            //   754b                 | jne                 0x4d
            //   68????????           |                     
            //   8d856cfeffff         | lea                 eax, [ebp - 0x194]
            //   50                   | push                eax
            //   ffd6                 | call                esi

        $sequence_1 = { 3314b590840010 8b75fc 3310 8b4dec }
            // n = 4, score = 100
            //   3314b590840010       | xor                 edx, dword ptr [esi*4 + 0x10008490]
            //   8b75fc               | mov                 esi, dword ptr [ebp - 4]
            //   3310                 | xor                 edx, dword ptr [eax]
            //   8b4dec               | mov                 ecx, dword ptr [ebp - 0x14]

        $sequence_2 = { 8b5dfc c1eb18 33349d90780010 8b5dec 8975f4 c1eb10 }
            // n = 6, score = 100
            //   8b5dfc               | mov                 ebx, dword ptr [ebp - 4]
            //   c1eb18               | shr                 ebx, 0x18
            //   33349d90780010       | xor                 esi, dword ptr [ebx*4 + 0x10007890]
            //   8b5dec               | mov                 ebx, dword ptr [ebp - 0x14]
            //   8975f4               | mov                 dword ptr [ebp - 0xc], esi
            //   c1eb10               | shr                 ebx, 0x10

        $sequence_3 = { c1eb10 337004 0fb6fb 8b5df0 }
            // n = 4, score = 100
            //   c1eb10               | shr                 ebx, 0x10
            //   337004               | xor                 esi, dword ptr [eax + 4]
            //   0fb6fb               | movzx               edi, bl
            //   8b5df0               | mov                 ebx, dword ptr [ebp - 0x10]

        $sequence_4 = { 33c0 668903 394508 740a ff7508 53 ff15???????? }
            // n = 7, score = 100
            //   33c0                 | xor                 eax, eax
            //   668903               | mov                 word ptr [ebx], ax
            //   394508               | cmp                 dword ptr [ebp + 8], eax
            //   740a                 | je                  0xc
            //   ff7508               | push                dword ptr [ebp + 8]
            //   53                   | push                ebx
            //   ff15????????         |                     

        $sequence_5 = { 744c ff7508 57 e8???????? 8944240c }
            // n = 5, score = 100
            //   744c                 | je                  0x4e
            //   ff7508               | push                dword ptr [ebp + 8]
            //   57                   | push                edi
            //   e8????????           |                     
            //   8944240c             | mov                 dword ptr [esp + 0xc], eax

        $sequence_6 = { 8b5c85dc 85db 75e5 eb07 c745f801000000 8b45f8 }
            // n = 6, score = 100
            //   8b5c85dc             | mov                 ebx, dword ptr [ebp + eax*4 - 0x24]
            //   85db                 | test                ebx, ebx
            //   75e5                 | jne                 0xffffffe7
            //   eb07                 | jmp                 9
            //   c745f801000000       | mov                 dword ptr [ebp - 8], 1
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]

        $sequence_7 = { ff35???????? ffd7 3975f0 740c ff75f0 56 ff35???????? }
            // n = 7, score = 100
            //   ff35????????         |                     
            //   ffd7                 | call                edi
            //   3975f0               | cmp                 dword ptr [ebp - 0x10], esi
            //   740c                 | je                  0xe
            //   ff75f0               | push                dword ptr [ebp - 0x10]
            //   56                   | push                esi
            //   ff35????????         |                     

        $sequence_8 = { 85c0 7c1e 8b4508 3bc3 }
            // n = 4, score = 100
            //   85c0                 | test                eax, eax
            //   7c1e                 | jl                  0x20
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   3bc3                 | cmp                 eax, ebx

        $sequence_9 = { ffd6 85c0 752e 68???????? }
            // n = 4, score = 100
            //   ffd6                 | call                esi
            //   85c0                 | test                eax, eax
            //   752e                 | jne                 0x30
            //   68????????           |                     

    condition:
        7 of them and filesize < 90112
}