rule win_pslogger_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.pslogger."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.pslogger"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8bc8 e8???????? 85c0 743b 4863f0 488bce e8???????? }
            // n = 7, score = 400
            //   8bc8                 | nop                 dword ptr [eax]
            //   e8????????           |                     
            //   85c0                 | mov                 ecx, eax
            //   743b                 | test                eax, eax
            //   4863f0               | je                  0x3d
            //   488bce               | dec                 eax
            //   e8????????           |                     

        $sequence_1 = { e8???????? e9???????? 4c8bc5 33d2 488bc8 e8???????? 4c8bc6 }
            // n = 7, score = 400
            //   e8????????           |                     
            //   e9????????           |                     
            //   4c8bc5               | dec                 ecx
            //   33d2                 | mov                 ebx, eax
            //   488bc8               | dec                 eax
            //   e8????????           |                     
            //   4c8bc6               | mov                 ecx, eax

        $sequence_2 = { e8???????? 488d8c2480030000 e8???????? 488d542420 }
            // n = 4, score = 400
            //   e8????????           |                     
            //   488d8c2480030000     | mov                 eax, esi
            //   e8????????           |                     
            //   488d542420           | jne                 0x13

        $sequence_3 = { 488bc8 e8???????? 8bc8 e8???????? 4863f0 85c0 750d }
            // n = 7, score = 400
            //   488bc8               | xor                 eax, esp
            //   e8????????           |                     
            //   8bc8                 | dec                 eax
            //   e8????????           |                     
            //   4863f0               | mov                 dword ptr [esp + 0x88], eax
            //   85c0                 | dec                 ecx
            //   750d                 | mov                 edi, ecx

        $sequence_4 = { 488b05???????? 4833c4 4889842488000000 498bf9 498bd8 }
            // n = 5, score = 400
            //   488b05????????       |                     
            //   4833c4               | arpl                ax, si
            //   4889842488000000     | dec                 eax
            //   498bf9               | mov                 ecx, esi
            //   498bd8               | dec                 eax

        $sequence_5 = { 488bf9 483b5908 7418 488b0b 4885c9 }
            // n = 5, score = 400
            //   488bf9               | arpl                ax, si
            //   483b5908             | test                eax, eax
            //   7418                 | jne                 0x16
            //   488b0b               | dec                 esp
            //   4885c9               | mov                 eax, ebp

        $sequence_6 = { 7406 ff15???????? 48891e 488bd3 488bcf ff15???????? }
            // n = 6, score = 400
            //   7406                 | nop                 dword ptr [eax]
            //   ff15????????         |                     
            //   48891e               | dec                 eax
            //   488bd3               | mov                 edi, ecx
            //   488bcf               | dec                 eax
            //   ff15????????         |                     

        $sequence_7 = { 4883ec28 803d????????00 7511 0f1f00 e8???????? 803d????????00 }
            // n = 6, score = 400
            //   4883ec28             | dec                 eax
            //   803d????????00       |                     
            //   7511                 | sub                 esp, 0x28
            //   0f1f00               | jne                 0x13
            //   e8????????           |                     
            //   803d????????00       |                     

        $sequence_8 = { 50 e8???????? 83c40c e9???????? 8d46cf }
            // n = 5, score = 100
            //   50                   | dec                 ecx
            //   e8????????           |                     
            //   83c40c               | mov                 ebx, eax
            //   e9????????           |                     
            //   8d46cf               | dec                 eax

        $sequence_9 = { c745e0284f4200 e9???????? c745e0244f4200 eba2 894ddc c745e0244f4200 }
            // n = 6, score = 100
            //   c745e0284f4200       | dec                 eax
            //   e9????????           |                     
            //   c745e0244f4200       | lea                 ecx, [esp + 0x380]
            //   eba2                 | dec                 eax
            //   894ddc               | lea                 edx, [esp + 0x20]
            //   c745e0244f4200       | je                  8

        $sequence_10 = { 0f82a6000000 83be78af060000 0f8499000000 6800800000 8d86702f0200 }
            // n = 5, score = 100
            //   0f82a6000000         | test                eax, eax
            //   83be78af060000       | jne                 0x16
            //   0f8499000000         | dec                 esp
            //   6800800000           | mov                 eax, ebp
            //   8d86702f0200         | xor                 edx, edx

        $sequence_11 = { 0f8544ffffff 56 ff15???????? 8b8c246c040000 5f }
            // n = 5, score = 100
            //   0f8544ffffff         | mov                 ecx, eax
            //   56                   | mov                 ecx, eax
            //   ff15????????         |                     
            //   8b8c246c040000       | dec                 eax
            //   5f                   | arpl                ax, si

        $sequence_12 = { 0f83af000000 8bde c1fb06 8bc6 83e03f }
            // n = 5, score = 100
            //   0f83af000000         | je                  0x1e
            //   8bde                 | dec                 eax
            //   c1fb06               | mov                 ecx, dword ptr [ebx]
            //   8bc6                 | dec                 eax
            //   83e03f               | test                ecx, ecx

        $sequence_13 = { e8???????? 8bd8 83c424 85db 0f84ef000000 8bce 8d5102 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8bd8                 | jne                 0x13
            //   83c424               | nop                 dword ptr [eax]
            //   85db                 | dec                 eax
            //   0f84ef000000         | mov                 edi, ecx
            //   8bce                 | dec                 eax
            //   8d5102               | cmp                 ebx, dword ptr [ecx + 8]

        $sequence_14 = { 32d2 85db 746c 85c9 756c 8b742420 }
            // n = 6, score = 100
            //   32d2                 | dec                 eax
            //   85db                 | mov                 ecx, eax
            //   746c                 | mov                 ecx, eax
            //   85c9                 | dec                 eax
            //   756c                 | arpl                ax, si
            //   8b742420             | test                eax, eax

        $sequence_15 = { 6bd830 56 8b048d88b14200 57 }
            // n = 4, score = 100
            //   6bd830               | dec                 eax
            //   56                   | mov                 ecx, eax
            //   8b048d88b14200       | dec                 esp
            //   57                   | mov                 eax, esi

    condition:
        7 of them and filesize < 475136
}