rule win_purelocker_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.purelocker."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.purelocker"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83e20f 53 56 8b742430 8d1c02 8b442438 c1fb04 }
            // n = 7, score = 100
            //   83e20f               | and                 edx, 0xf
            //   53                   | push                ebx
            //   56                   | push                esi
            //   8b742430             | mov                 esi, dword ptr [esp + 0x30]
            //   8d1c02               | lea                 ebx, [edx + eax]
            //   8b442438             | mov                 eax, dword ptr [esp + 0x38]
            //   c1fb04               | sar                 ebx, 4

        $sequence_1 = { 5b 5f 83fb00 7505 83ff00 7404 31c0 }
            // n = 7, score = 100
            //   5b                   | pop                 ebx
            //   5f                   | pop                 edi
            //   83fb00               | cmp                 ebx, 0
            //   7505                 | jne                 7
            //   83ff00               | cmp                 edi, 0
            //   7404                 | je                  6
            //   31c0                 | xor                 eax, eax

        $sequence_2 = { 898424c0000000 8b9c24c0000000 21db 744e ffb424bc000000 e8???????? }
            // n = 6, score = 100
            //   898424c0000000       | mov                 dword ptr [esp + 0xc0], eax
            //   8b9c24c0000000       | mov                 ebx, dword ptr [esp + 0xc0]
            //   21db                 | and                 ebx, ebx
            //   744e                 | je                  0x50
            //   ffb424bc000000       | push                dword ptr [esp + 0xbc]
            //   e8????????           |                     

        $sequence_3 = { 5f 3bbc249c000000 7f0f 7c09 3b9c2498000000 7704 }
            // n = 6, score = 100
            //   5f                   | pop                 edi
            //   3bbc249c000000       | cmp                 edi, dword ptr [esp + 0x9c]
            //   7f0f                 | jg                  0x11
            //   7c09                 | jl                  0xb
            //   3b9c2498000000       | cmp                 ebx, dword ptr [esp + 0x98]
            //   7704                 | ja                  6

        $sequence_4 = { e8???????? 8b542418 52 e8???????? 5a 50 52 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8b542418             | mov                 edx, dword ptr [esp + 0x18]
            //   52                   | push                edx
            //   e8????????           |                     
            //   5a                   | pop                 edx
            //   50                   | push                eax
            //   52                   | push                edx

        $sequence_5 = { 5f 6a0c 6a00 ff35???????? ff15???????? }
            // n = 5, score = 100
            //   5f                   | pop                 edi
            //   6a0c                 | push                0xc
            //   6a00                 | push                0
            //   ff35????????         |                     
            //   ff15????????         |                     

        $sequence_6 = { 85c0 746f 0fb708 8bf8 6a22 5a 663bca }
            // n = 7, score = 100
            //   85c0                 | test                eax, eax
            //   746f                 | je                  0x71
            //   0fb708               | movzx               ecx, word ptr [eax]
            //   8bf8                 | mov                 edi, eax
            //   6a22                 | push                0x22
            //   5a                   | pop                 edx
            //   663bca               | cmp                 cx, dx

        $sequence_7 = { 8d4508 50 e8???????? 8b4c2420 83c410 890f 8b4c2414 }
            // n = 7, score = 100
            //   8d4508               | lea                 eax, [ebp + 8]
            //   50                   | push                eax
            //   e8????????           |                     
            //   8b4c2420             | mov                 ecx, dword ptr [esp + 0x20]
            //   83c410               | add                 esp, 0x10
            //   890f                 | mov                 dword ptr [edi], ecx
            //   8b4c2414             | mov                 ecx, dword ptr [esp + 0x14]

        $sequence_8 = { ff742454 e8???????? 89442450 8b5c2450 21db 7516 }
            // n = 6, score = 100
            //   ff742454             | push                dword ptr [esp + 0x54]
            //   e8????????           |                     
            //   89442450             | mov                 dword ptr [esp + 0x50], eax
            //   8b5c2450             | mov                 ebx, dword ptr [esp + 0x50]
            //   21db                 | and                 ebx, ebx
            //   7516                 | jne                 0x18

        $sequence_9 = { 33c1 894f10 8b4f08 894714 33c8 8bc3 894f18 }
            // n = 7, score = 100
            //   33c1                 | xor                 eax, ecx
            //   894f10               | mov                 dword ptr [edi + 0x10], ecx
            //   8b4f08               | mov                 ecx, dword ptr [edi + 8]
            //   894714               | mov                 dword ptr [edi + 0x14], eax
            //   33c8                 | xor                 ecx, eax
            //   8bc3                 | mov                 eax, ebx
            //   894f18               | mov                 dword ptr [edi + 0x18], ecx

    condition:
        7 of them and filesize < 193536
}