rule win_purplefox_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.purplefox."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.purplefox"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 33c0 48898500040000 8bd8 4c899df8030000 90 }
            // n = 5, score = 100
            //   33c0                 | test                eax, eax
            //   48898500040000       | js                  0x1cd
            //   8bd8                 | dec                 eax
            //   4c899df8030000       | mov                 ecx, dword ptr [ebp + 0x408]
            //   90                   | dec                 eax

        $sequence_1 = { 64bba3ae1c94 af 6c 7924 5e 52 }
            // n = 6, score = 100
            //   64bba3ae1c94         | xor                 ebp, ebp
            //   af                   | dec                 eax
            //   6c                   | mov                 ecx, eax
            //   7924                 | dec                 eax
            //   5e                   | lea                 edx, [0x4628]
            //   52                   | dec                 eax

        $sequence_2 = { 488d05fc900000 488b4c2430 483bc8 7405 e8???????? 488b05???????? }
            // n = 6, score = 100
            //   488d05fc900000       | dec                 eax
            //   488b4c2430           | cmp                 dword ptr [eax - 0x10], edx
            //   483bc8               | je                  0xd
            //   7405                 | dec                 eax
            //   e8????????           |                     
            //   488b05????????       |                     

        $sequence_3 = { 8b0a 6a00 51 6800000100 50 ff15???????? 8bf0 }
            // n = 7, score = 100
            //   8b0a                 | mov                 ecx, dword ptr [edx]
            //   6a00                 | push                0
            //   51                   | push                ecx
            //   6800000100           | push                0x10000
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8bf0                 | mov                 esi, eax

        $sequence_4 = { 4c8b642450 0f84c5000000 488364242000 488d05e17f0000 c64424600d 4a8b0ce0 }
            // n = 6, score = 100
            //   4c8b642450           | lea                 ecx, [esp + 0x20]
            //   0f84c5000000         | jmp                 0x25
            //   488364242000         | dec                 eax
            //   488d05e17f0000       | mov                 edx, dword ptr [edi + 0x10]
            //   c64424600d           | dec                 eax
            //   4a8b0ce0             | lea                 ecx, [0xb121]

        $sequence_5 = { e8???????? e9???????? 8b570c 8b4708 }
            // n = 4, score = 100
            //   e8????????           |                     
            //   e9????????           |                     
            //   8b570c               | xor                 al, 0x8a
            //   8b4708               | nop                 

        $sequence_6 = { 750a b80d0000c0 e9???????? 488d7768 }
            // n = 4, score = 100
            //   750a                 | pop                 ebp
            //   b80d0000c0           | ret                 
            //   e9????????           |                     
            //   488d7768             | jne                 0xc

        $sequence_7 = { 0f88c9000000 488b4c2460 ff15???????? 4839442470 0f85b3000000 488d542460 488bce }
            // n = 7, score = 100
            //   0f88c9000000         | mov                 ebx, eax
            //   488b4c2460           | dec                 esp
            //   ff15????????         |                     
            //   4839442470           | mov                 dword ptr [ebp + 0x3f8], ebx
            //   0f85b3000000         | nop                 
            //   488d542460           | dec                 eax
            //   488bce               | lea                 ecx, [0x1055]

        $sequence_8 = { 488d4c2420 e8???????? eb1e 488b5710 488d0d21b10000 e8???????? 488b5710 }
            // n = 7, score = 100
            //   488d4c2420           | dec                 eax
            //   e8????????           |                     
            //   eb1e                 | mov                 ecx, esi
            //   488b5710             | dec                 eax
            //   488d0d21b10000       | lea                 eax, [ebp + 0x180]
            //   e8????????           |                     
            //   488b5710             | dec                 eax

        $sequence_9 = { 85c0 0f88c7010000 4c8b05???????? 488b8d08040000 488d442470 }
            // n = 5, score = 100
            //   85c0                 | mov                 dword ptr [esp + 0x68], 0x100
            //   0f88c7010000         | dec                 eax
            //   4c8b05????????       |                     
            //   488b8d08040000       | mov                 dword ptr [esp + 0x60], esi
            //   488d442470           | mov                 dword ptr [esp + 0x58], esi

        $sequence_10 = { d565 96 dcb2503c62fc b23e ac 82d0e0 e460 }
            // n = 7, score = 100
            //   d565                 | jmp                 0x17
            //   96                   | dec                 eax
            //   dcb2503c62fc         | mov                 eax, dword ptr [ebx]
            //   b23e                 | dec                 eax
            //   ac                   | test                eax, eax
            //   82d0e0               | je                  0xa
            //   e460                 | dec                 esp

        $sequence_11 = { 55 8bec 33c0 8b4d08 3b0cc528bb4000 740a 40 }
            // n = 7, score = 100
            //   55                   | mov                 esi, 0x78121a7c
            //   8bec                 | add                 al, 0xb2
            //   33c0                 | jp                  4
            //   8b4d08               | mov                 esp, 0x567ad40a
            //   3b0cc528bb4000       | mov                 ebx, 0x941caea3
            //   740a                 | scasd               eax, dword ptr es:[edi]
            //   40                   | insb                byte ptr es:[edi], dx

        $sequence_12 = { e8???????? 488b5710 488d4c2420 e8???????? }
            // n = 4, score = 100
            //   e8????????           |                     
            //   488b5710             | js                  0xcf
            //   488d4c2420           | dec                 eax
            //   e8????????           |                     

        $sequence_13 = { 56 6a1b 52 ffd7 85c0 7918 6a00 }
            // n = 7, score = 100
            //   56                   | push                esi
            //   6a1b                 | push                0x1b
            //   52                   | push                edx
            //   ffd7                 | call                edi
            //   85c0                 | test                eax, eax
            //   7918                 | jns                 0x1a
            //   6a00                 | push                0

        $sequence_14 = { 8bd8 85c0 0f8882000000 c744246800010000 4889742460 89742458 }
            // n = 6, score = 100
            //   8bd8                 | mov                 eax, 0xc000000d
            //   85c0                 | dec                 eax
            //   0f8882000000         | lea                 esi, [edi + 0x68]
            //   c744246800010000     | mov                 ebx, eax
            //   4889742460           | test                eax, eax
            //   89742458             | js                  0x8a

        $sequence_15 = { 6a00 6a00 68000000c0 68???????? ff15???????? 8985e0fdffff }
            // n = 6, score = 100
            //   6a00                 | mov                 ebp, 0x9a908f1d
            //   6a00                 | xor                 byte ptr [ebp + 0x401b4963], ah
            //   68000000c0           | pop                 esi
            //   68????????           |                     
            //   ff15????????         |                     
            //   8985e0fdffff         | dec                 ebx

        $sequence_16 = { ff75e0 ff15???????? c9 c20800 6a00 6800100000 }
            // n = 6, score = 100
            //   ff75e0               | pushal              
            //   ff15????????         |                     
            //   c9                   | shl                 al, 2
            //   c20800               | mov                 al, 0x2e
            //   6a00                 | stc                 
            //   6800100000           | add                 al, 0x83

        $sequence_17 = { 488d0d1b0f0000 ff15???????? 8bc7 eb02 33c0 }
            // n = 5, score = 100
            //   488d0d1b0f0000       | dec                 eax
            //   ff15????????         |                     
            //   8bc7                 | lea                 ecx, [0xf1b]
            //   eb02                 | mov                 eax, edi
            //   33c0                 | jmp                 4

        $sequence_18 = { 348a 90 be7c1a1278 04b2 7a00 bc0ad47a56 }
            // n = 6, score = 100
            //   348a                 | push                esi
            //   90                   | push                edi
            //   be7c1a1278           | dec                 eax
            //   04b2                 | sub                 esp, 0x30
            //   7a00                 | dec                 eax
            //   bc0ad47a56           | lea                 edi, [0xb4a9]

        $sequence_19 = { 9c f5 83c506 66892424 }
            // n = 4, score = 100
            //   9c                   | dec                 eax
            //   f5                   | lea                 eax, [0x7fe1]
            //   83c506               | mov                 byte ptr [esp + 0x60], 0xd
            //   66892424             | dec                 edx

        $sequence_20 = { 488bc8 ff15???????? 488d1528460000 488bce 488905???????? ff15???????? 488bc8 }
            // n = 7, score = 100
            //   488bc8               | dec                 eax
            //   ff15????????         |                     
            //   488d1528460000       | lea                 ecx, [esp + 0x20]
            //   488bce               | dec                 eax
            //   488905????????       |                     
            //   ff15????????         |                     
            //   488bc8               | lea                 edx, [0x9078]

        $sequence_21 = { 57 56 6a0b ffd3 3d040000c0 750d }
            // n = 6, score = 100
            //   57                   | adc                 al, 0xe0
            //   56                   | in                  al, 0x60
            //   6a0b                 | bt                  ebx, eax
            //   ffd3                 | lea                 eax, [esi - 0x3cb951e4]
            //   3d040000c0           | mov                 ax, 0x30f2
            //   750d                 | mov                 eax, dword ptr [ebp]

        $sequence_22 = { 8945d0 8945d4 8945dc c745d880000000 }
            // n = 4, score = 100
            //   8945d0               | mov                 dword ptr [ebp - 0x30], eax
            //   8945d4               | mov                 dword ptr [ebp - 0x2c], eax
            //   8945dc               | mov                 dword ptr [ebp - 0x24], eax
            //   c745d880000000       | mov                 dword ptr [ebp - 0x28], 0x80

        $sequence_23 = { e9???????? 0fa3c3 8d861cae46c3 66b8f230 8b4500 }
            // n = 5, score = 100
            //   e9????????           |                     
            //   0fa3c3               | mov                 esp, dword ptr [esp + 0x50]
            //   8d861cae46c3         | je                  0xcb
            //   66b8f230             | dec                 eax
            //   8b4500               | and                 dword ptr [esp + 0x20], 0

        $sequence_24 = { 488d0d55100000 ff15???????? 488b6c2450 8bc3 488b5c2468 }
            // n = 5, score = 100
            //   488d0d55100000       | lea                 eax, [esp + 0x70]
            //   ff15????????         |                     
            //   488b6c2450           | xor                 eax, eax
            //   8bc3                 | dec                 eax
            //   488b5c2468           | mov                 dword ptr [ebp + 0x400], eax

        $sequence_25 = { ff15???????? 8bc3 4881c4d0000000 5e 5b 5d c3 }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   8bc3                 | xor                 eax, eax
            //   4881c4d0000000       | mov                 eax, ebx
            //   5e                   | dec                 eax
            //   5b                   | add                 esp, 0xd0
            //   5d                   | pop                 esi
            //   c3                   | pop                 ebx

        $sequence_26 = { 8d45ec e8???????? 33c0 0175dc 6800040000 }
            // n = 5, score = 100
            //   8d45ec               | lea                 eax, [ebp - 0x14]
            //   e8????????           |                     
            //   33c0                 | xor                 eax, eax
            //   0175dc               | add                 dword ptr [ebp - 0x24], esi
            //   6800040000           | push                0x400

        $sequence_27 = { 83e61f 8d3c85000c4100 8b07 c1e606 f644300401 }
            // n = 5, score = 100
            //   83e61f               | aad                 0x65
            //   8d3c85000c4100       | xchg                eax, esi
            //   8b07                 | fdiv                qword ptr [edx - 0x39dc3b0]
            //   c1e606               | mov                 dl, 0x3e
            //   f644300401           | lodsb               al, byte ptr [esi]

        $sequence_28 = { 7681 f1 6c 3c9f 7d8b 017b29 }
            // n = 6, score = 100
            //   7681                 | mov                 ecx, dword ptr [eax]
            //   f1                   | inc                 esp
            //   6c                   | mov                 ebp, eax
            //   3c9f                 | test                eax, eax
            //   7d8b                 | jne                 0x112
            //   017b29               | dec                 eax

        $sequence_29 = { 8d95defdffff 33c9 52 8945f8 8945f4 8945f0 }
            // n = 6, score = 100
            //   8d95defdffff         | lea                 edx, [ebp - 0x222]
            //   33c9                 | xor                 ecx, ecx
            //   52                   | push                edx
            //   8945f8               | mov                 dword ptr [ebp - 8], eax
            //   8945f4               | mov                 dword ptr [ebp - 0xc], eax
            //   8945f0               | mov                 dword ptr [ebp - 0x10], eax

        $sequence_30 = { 488d3d4c610000 eb0e 488b03 4885c0 7402 }
            // n = 5, score = 100
            //   488d3d4c610000       | mov                 edx, dword ptr [eax]
            //   eb0e                 | dec                 eax
            //   488b03               | test                edx, edx
            //   4885c0               | je                  0xd
            //   7402                 | dec                 eax

        $sequence_31 = { 0483 bd1d8f909a 30a563491b40 5e a0???????? 4b }
            // n = 6, score = 100
            //   0483                 | dec                 eax
            //   bd1d8f909a           | cmp                 ecx, eax
            //   30a563491b40         | je                  0xa
            //   5e                   | dec                 eax
            //   a0????????           |                     
            //   4b                   | lea                 edi, [0x614c]

        $sequence_32 = { 6800020000 50 ff15???????? 85c0 790a 8b4df8 ffd3 }
            // n = 7, score = 100
            //   6800020000           | push                0x200
            //   50                   | push                eax
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   790a                 | jns                 0xc
            //   8b4df8               | mov                 ecx, dword ptr [ebp - 8]
            //   ffd3                 | call                ebx

        $sequence_33 = { 8978f0 8b4df8 8948f4 c740e001000000 c740e40d000000 }
            // n = 5, score = 100
            //   8978f0               | mov                 dword ptr [eax - 0x10], edi
            //   8b4df8               | mov                 ecx, dword ptr [ebp - 8]
            //   8948f4               | mov                 dword ptr [eax - 0xc], ecx
            //   c740e001000000       | mov                 dword ptr [eax - 0x20], 1
            //   c740e40d000000       | mov                 dword ptr [eax - 0x1c], 0xd

        $sequence_34 = { 89df 2cfd 60 60 c0e002 b02e f9 }
            // n = 7, score = 100
            //   89df                 | mov                 ecx, esi
            //   2cfd                 | dec                 eax
            //   60                   | mov                 ecx, eax
            //   60                   | dec                 eax
            //   c0e002               | lea                 eax, [0x90fc]
            //   b02e                 | dec                 eax
            //   f9                   | mov                 ecx, dword ptr [esp + 0x30]

        $sequence_35 = { 51 50 e8???????? 85c0 7417 c70701000000 8b07 }
            // n = 7, score = 100
            //   51                   | jns                 0x27
            //   50                   | pop                 esi
            //   e8????????           |                     
            //   85c0                 | push                edx
            //   7417                 | mov                 edi, ebx
            //   c70701000000         | sub                 al, 0xfd
            //   8b07                 | pushal              

        $sequence_36 = { 81fe00000001 7708 81c600100000 eb9b 8d4dc4 51 ff15???????? }
            // n = 7, score = 100
            //   81fe00000001         | cmp                 esi, 0x1000000
            //   7708                 | ja                  0xa
            //   81c600100000         | add                 esi, 0x1000
            //   eb9b                 | jmp                 0xffffff9d
            //   8d4dc4               | lea                 ecx, [ebp - 0x3c]
            //   51                   | push                ecx
            //   ff15????????         |                     

        $sequence_37 = { 56 e8???????? 8bc6 c1f805 8b0485000c4100 83e61f c1e606 }
            // n = 7, score = 100
            //   56                   | pushfd              
            //   e8????????           |                     
            //   8bc6                 | cmc                 
            //   c1f805               | add                 ebp, 6
            //   8b0485000c4100       | mov                 word ptr [esp], sp
            //   83e61f               | jbe                 0xffffff83
            //   c1e606               | int1                

        $sequence_38 = { 488d1578900000 483950f0 740b 488b10 4885d2 7403 }
            // n = 6, score = 100
            //   488d1578900000       | mov                 ecx, dword ptr [esp + 0x60]
            //   483950f0             | dec                 eax
            //   740b                 | cmp                 dword ptr [esp + 0x70], eax
            //   488b10               | jne                 0xc3
            //   4885d2               | dec                 eax
            //   7403                 | lea                 edx, [esp + 0x60]

        $sequence_39 = { 48895c2418 55 56 57 4883ec30 488d3da9b40000 33ed }
            // n = 7, score = 100
            //   48895c2418           | lea                 ecx, [esp + 0x20]
            //   55                   | mov                 dword ptr [esp + 0x20], 0x2080000
            //   56                   | mov                 dword ptr [esp + 0x30], 0x2080000
            //   57                   | dec                 eax
            //   4883ec30             | mov                 dword ptr [esp + 0x38], eax
            //   488d3da9b40000       | dec                 eax
            //   33ed                 | mov                 edx, dword ptr [edi + 0x10]

    condition:
        7 of them and filesize < 1983488
}