rule win_r980_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.r980."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.r980"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 85c0 755b 6a04 e8???????? 83c404 8945f0 8bc8 }
            // n = 7, score = 200
            //   85c0                 | test                eax, eax
            //   755b                 | jne                 0x5d
            //   6a04                 | push                4
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   8945f0               | mov                 dword ptr [ebp - 0x10], eax
            //   8bc8                 | mov                 ecx, eax

        $sequence_1 = { ff742428 e8???????? 53 8b5c2430 6a00 8d041f 50 }
            // n = 7, score = 200
            //   ff742428             | push                dword ptr [esp + 0x28]
            //   e8????????           |                     
            //   53                   | push                ebx
            //   8b5c2430             | mov                 ebx, dword ptr [esp + 0x30]
            //   6a00                 | push                0
            //   8d041f               | lea                 eax, [edi + ebx]
            //   50                   | push                eax

        $sequence_2 = { c7458001000000 c7857cffffff26000000 c745843d000000 6a01 57 8d857cffffff 8bcb }
            // n = 7, score = 200
            //   c7458001000000       | mov                 dword ptr [ebp - 0x80], 1
            //   c7857cffffff26000000     | mov    dword ptr [ebp - 0x84], 0x26
            //   c745843d000000       | mov                 dword ptr [ebp - 0x7c], 0x3d
            //   6a01                 | push                1
            //   57                   | push                edi
            //   8d857cffffff         | lea                 eax, [ebp - 0x84]
            //   8bcb                 | mov                 ecx, ebx

        $sequence_3 = { 7422 8b55a8 83e1ef 894dd8 894dd4 85d2 7412 }
            // n = 7, score = 200
            //   7422                 | je                  0x24
            //   8b55a8               | mov                 edx, dword ptr [ebp - 0x58]
            //   83e1ef               | and                 ecx, 0xffffffef
            //   894dd8               | mov                 dword ptr [ebp - 0x28], ecx
            //   894dd4               | mov                 dword ptr [ebp - 0x2c], ecx
            //   85d2                 | test                edx, edx
            //   7412                 | je                  0x14

        $sequence_4 = { 8955fc 8bc4 8965e8 c7401407000000 895010 83781408 7202 }
            // n = 7, score = 200
            //   8955fc               | mov                 dword ptr [ebp - 4], edx
            //   8bc4                 | mov                 eax, esp
            //   8965e8               | mov                 dword ptr [ebp - 0x18], esp
            //   c7401407000000       | mov                 dword ptr [eax + 0x14], 7
            //   895010               | mov                 dword ptr [eax + 0x10], edx
            //   83781408             | cmp                 dword ptr [eax + 0x14], 8
            //   7202                 | jb                  4

        $sequence_5 = { 8bc7 f00fc14104 7515 8b01 ff10 8b4db4 8bc7 }
            // n = 7, score = 200
            //   8bc7                 | mov                 eax, edi
            //   f00fc14104           | lock xadd           dword ptr [ecx + 4], eax
            //   7515                 | jne                 0x17
            //   8b01                 | mov                 eax, dword ptr [ecx]
            //   ff10                 | call                dword ptr [eax]
            //   8b4db4               | mov                 ecx, dword ptr [ebp - 0x4c]
            //   8bc7                 | mov                 eax, edi

        $sequence_6 = { 7279 e8???????? 85c0 7570 6804010000 8d85e0fbffff 50 }
            // n = 7, score = 200
            //   7279                 | jb                  0x7b
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   7570                 | jne                 0x72
            //   6804010000           | push                0x104
            //   8d85e0fbffff         | lea                 eax, [ebp - 0x420]
            //   50                   | push                eax

        $sequence_7 = { e8???????? e9???????? 68???????? 8d4dd8 e8???????? 8d45d8 c745fc01000000 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   e9????????           |                     
            //   68????????           |                     
            //   8d4dd8               | lea                 ecx, [ebp - 0x28]
            //   e8????????           |                     
            //   8d45d8               | lea                 eax, [ebp - 0x28]
            //   c745fc01000000       | mov                 dword ptr [ebp - 4], 1

        $sequence_8 = { 8975f0 c745fc00000000 85f6 7416 8d4e08 c645fc01 50 }
            // n = 7, score = 200
            //   8975f0               | mov                 dword ptr [ebp - 0x10], esi
            //   c745fc00000000       | mov                 dword ptr [ebp - 4], 0
            //   85f6                 | test                esi, esi
            //   7416                 | je                  0x18
            //   8d4e08               | lea                 ecx, [esi + 8]
            //   c645fc01             | mov                 byte ptr [ebp - 4], 1
            //   50                   | push                eax

        $sequence_9 = { 8b4634 3b4630 75a5 e9???????? 2b5e10 b801000000 5f }
            // n = 7, score = 200
            //   8b4634               | mov                 eax, dword ptr [esi + 0x34]
            //   3b4630               | cmp                 eax, dword ptr [esi + 0x30]
            //   75a5                 | jne                 0xffffffa7
            //   e9????????           |                     
            //   2b5e10               | sub                 ebx, dword ptr [esi + 0x10]
            //   b801000000           | mov                 eax, 1
            //   5f                   | pop                 edi

    condition:
        7 of them and filesize < 3178496
}