rule win_racket_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.racket."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.racket"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 757b e8???????? 3906 7572 837e0c00 756c 8b4608 }
            // n = 7, score = 100
            //   757b                 | jne                 0x7d
            //   e8????????           |                     
            //   3906                 | cmp                 dword ptr [esi], eax
            //   7572                 | jne                 0x74
            //   837e0c00             | cmp                 dword ptr [esi + 0xc], 0
            //   756c                 | jne                 0x6e
            //   8b4608               | mov                 eax, dword ptr [esi + 8]

        $sequence_1 = { 7507 c74634f4af0510 6a00 57 8bce e8???????? 5f }
            // n = 7, score = 100
            //   7507                 | jne                 9
            //   c74634f4af0510       | mov                 dword ptr [esi + 0x34], 0x1005aff4
            //   6a00                 | push                0
            //   57                   | push                edi
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     
            //   5f                   | pop                 edi

        $sequence_2 = { e8???????? 8b5590 8b4d8c 8bbd70ffffff 83c104 83ea01 894d8c }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8b5590               | mov                 edx, dword ptr [ebp - 0x70]
            //   8b4d8c               | mov                 ecx, dword ptr [ebp - 0x74]
            //   8bbd70ffffff         | mov                 edi, dword ptr [ebp - 0x90]
            //   83c104               | add                 ecx, 4
            //   83ea01               | sub                 edx, 1
            //   894d8c               | mov                 dword ptr [ebp - 0x74], ecx

        $sequence_3 = { e8???????? 83c40c 8d8ddcfaffff 68???????? e8???????? 6804010000 8d85e0fbffff }
            // n = 7, score = 100
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   8d8ddcfaffff         | lea                 ecx, [ebp - 0x524]
            //   68????????           |                     
            //   e8????????           |                     
            //   6804010000           | push                0x104
            //   8d85e0fbffff         | lea                 eax, [ebp - 0x420]

        $sequence_4 = { 8b9568ffffff 8b4214 394218 7420 8b4dac 8908 c7400400000000 }
            // n = 7, score = 100
            //   8b9568ffffff         | mov                 edx, dword ptr [ebp - 0x98]
            //   8b4214               | mov                 eax, dword ptr [edx + 0x14]
            //   394218               | cmp                 dword ptr [edx + 0x18], eax
            //   7420                 | je                  0x22
            //   8b4dac               | mov                 ecx, dword ptr [ebp - 0x54]
            //   8908                 | mov                 dword ptr [eax], ecx
            //   c7400400000000       | mov                 dword ptr [eax + 4], 0

        $sequence_5 = { 50 e8???????? 6a00 8d8558f6ffff 50 6aff 8d855cf6ffff }
            // n = 7, score = 100
            //   50                   | push                eax
            //   e8????????           |                     
            //   6a00                 | push                0
            //   8d8558f6ffff         | lea                 eax, [ebp - 0x9a8]
            //   50                   | push                eax
            //   6aff                 | push                -1
            //   8d855cf6ffff         | lea                 eax, [ebp - 0x9a4]

        $sequence_6 = { 8b4da4 eb03 8b45e0 837dc400 893488 745c 8b45f4 }
            // n = 7, score = 100
            //   8b4da4               | mov                 ecx, dword ptr [ebp - 0x5c]
            //   eb03                 | jmp                 5
            //   8b45e0               | mov                 eax, dword ptr [ebp - 0x20]
            //   837dc400             | cmp                 dword ptr [ebp - 0x3c], 0
            //   893488               | mov                 dword ptr [eax + ecx*4], esi
            //   745c                 | je                  0x5e
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]

        $sequence_7 = { 660f56c3 660f58e0 660fc5c400 25f0070000 660f28a050f70510 660f28b840f30510 660f54f0 }
            // n = 7, score = 100
            //   660f56c3             | orpd                xmm0, xmm3
            //   660f58e0             | addpd               xmm4, xmm0
            //   660fc5c400           | pextrw              eax, xmm4, 0
            //   25f0070000           | and                 eax, 0x7f0
            //   660f28a050f70510     | movapd              xmm4, xmmword ptr [eax + 0x1005f750]
            //   660f28b840f30510     | movapd              xmm7, xmmword ptr [eax + 0x1005f340]
            //   660f54f0             | andpd               xmm6, xmm0

        $sequence_8 = { 56 e8???????? e8???????? 6a00 ffb5c8feffff 56 e8???????? }
            // n = 7, score = 100
            //   56                   | push                esi
            //   e8????????           |                     
            //   e8????????           |                     
            //   6a00                 | push                0
            //   ffb5c8feffff         | push                dword ptr [ebp - 0x138]
            //   56                   | push                esi
            //   e8????????           |                     

        $sequence_9 = { 8bd0 8b37 2bd6 8b4d0c 8945e0 b8ffa16f6b f7ea }
            // n = 7, score = 100
            //   8bd0                 | mov                 edx, eax
            //   8b37                 | mov                 esi, dword ptr [edi]
            //   2bd6                 | sub                 edx, esi
            //   8b4d0c               | mov                 ecx, dword ptr [ebp + 0xc]
            //   8945e0               | mov                 dword ptr [ebp - 0x20], eax
            //   b8ffa16f6b           | mov                 eax, 0x6b6fa1ff
            //   f7ea                 | imul                edx

    condition:
        7 of them and filesize < 985088
}