rule win_ragnarok_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.ragnarok."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.ragnarok"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 51 ff35???????? ffd3 8bf8 8d8540ffffff 50 }
            // n = 6, score = 200
            //   51                   | push                ecx
            //   ff35????????         |                     
            //   ffd3                 | call                ebx
            //   8bf8                 | mov                 edi, eax
            //   8d8540ffffff         | lea                 eax, [ebp - 0xc0]
            //   50                   | push                eax

        $sequence_1 = { 0fb6c9 0fb689104b4300 c1e108 33d9 8b4d10 c1e910 0fb6c9 }
            // n = 7, score = 200
            //   0fb6c9               | movzx               ecx, cl
            //   0fb689104b4300       | movzx               ecx, byte ptr [ecx + 0x434b10]
            //   c1e108               | shl                 ecx, 8
            //   33d9                 | xor                 ebx, ecx
            //   8b4d10               | mov                 ecx, dword ptr [ebp + 0x10]
            //   c1e910               | shr                 ecx, 0x10
            //   0fb6c9               | movzx               ecx, cl

        $sequence_2 = { 238574fdffff 338568fdffff 03d9 8b8d58fdffff 13f8 8b8538fdffff 031cc588af4200 }
            // n = 7, score = 200
            //   238574fdffff         | and                 eax, dword ptr [ebp - 0x28c]
            //   338568fdffff         | xor                 eax, dword ptr [ebp - 0x298]
            //   03d9                 | add                 ebx, ecx
            //   8b8d58fdffff         | mov                 ecx, dword ptr [ebp - 0x2a8]
            //   13f8                 | adc                 edi, eax
            //   8b8538fdffff         | mov                 eax, dword ptr [ebp - 0x2c8]
            //   031cc588af4200       | add                 ebx, dword ptr [eax*8 + 0x42af88]

        $sequence_3 = { 83c410 5d c3 e8???????? 50 e8???????? 59 }
            // n = 7, score = 200
            //   83c410               | add                 esp, 0x10
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   e8????????           |                     
            //   50                   | push                eax
            //   e8????????           |                     
            //   59                   | pop                 ecx

        $sequence_4 = { 88043e 46 83fe40 7ce6 }
            // n = 4, score = 200
            //   88043e               | mov                 byte ptr [esi + edi], al
            //   46                   | inc                 esi
            //   83fe40               | cmp                 esi, 0x40
            //   7ce6                 | jl                  0xffffffe8

        $sequence_5 = { 0b45a0 33c1 895db0 0345e8 03c2 }
            // n = 5, score = 200
            //   0b45a0               | or                  eax, dword ptr [ebp - 0x60]
            //   33c1                 | xor                 eax, ecx
            //   895db0               | mov                 dword ptr [ebp - 0x50], ebx
            //   0345e8               | add                 eax, dword ptr [ebp - 0x18]
            //   03c2                 | add                 eax, edx

        $sequence_6 = { 8bf8 83c40c 85ff 7576 8b4d08 8bc6 99 }
            // n = 7, score = 200
            //   8bf8                 | mov                 edi, eax
            //   83c40c               | add                 esp, 0xc
            //   85ff                 | test                edi, edi
            //   7576                 | jne                 0x78
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   8bc6                 | mov                 eax, esi
            //   99                   | cdq                 

        $sequence_7 = { 8b048528754300 5f 894df4 c644032b0a 8b5d08 753b }
            // n = 6, score = 200
            //   8b048528754300       | mov                 eax, dword ptr [eax*4 + 0x437528]
            //   5f                   | pop                 edi
            //   894df4               | mov                 dword ptr [ebp - 0xc], ecx
            //   c644032b0a           | mov                 byte ptr [ebx + eax + 0x2b], 0xa
            //   8b5d08               | mov                 ebx, dword ptr [ebp + 8]
            //   753b                 | jne                 0x3d

        $sequence_8 = { 334d0c 034df8 034d98 c1c00a 8945ac 8b450c c1c105 }
            // n = 7, score = 200
            //   334d0c               | xor                 ecx, dword ptr [ebp + 0xc]
            //   034df8               | add                 ecx, dword ptr [ebp - 8]
            //   034d98               | add                 ecx, dword ptr [ebp - 0x68]
            //   c1c00a               | rol                 eax, 0xa
            //   8945ac               | mov                 dword ptr [ebp - 0x54], eax
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   c1c105               | rol                 ecx, 5

        $sequence_9 = { 0f87a9000000 ff24858d6e4100 ff7510 ff750c }
            // n = 4, score = 200
            //   0f87a9000000         | ja                  0xaf
            //   ff24858d6e4100       | jmp                 dword ptr [eax*4 + 0x416e8d]
            //   ff7510               | push                dword ptr [ebp + 0x10]
            //   ff750c               | push                dword ptr [ebp + 0xc]

    condition:
        7 of them and filesize < 483328
}