rule win_rakhni_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2020-10-14"
        version = "1"
        description = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.5.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.rakhni"
        malpedia_rule_date = "20201014"
        malpedia_hash = "a7e3bd57eaf12bf3ea29a863c041091ba3af9ac9"
        malpedia_version = "20201014"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 50 8b83a8000000 8b4dfc 0fb755ea e8???????? 8b4da8 8b83d0000000 }
            // n = 7, score = 200
            //   50                   | push                eax
            //   8b83a8000000         | mov                 eax, dword ptr [ebx + 0xa8]
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   0fb755ea             | movzx               edx, word ptr [ebp - 0x16]
            //   e8????????           |                     
            //   8b4da8               | mov                 ecx, dword ptr [ebp - 0x58]
            //   8b83d0000000         | mov                 eax, dword ptr [ebx + 0xd0]

        $sequence_1 = { 50 8d55c8 b8???????? e8???????? 59 8b55c8 8b45f4 }
            // n = 7, score = 200
            //   50                   | push                eax
            //   8d55c8               | lea                 edx, [ebp - 0x38]
            //   b8????????           |                     
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   8b55c8               | mov                 edx, dword ptr [ebp - 0x38]
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]

        $sequence_2 = { 8b45d8 8b15???????? e8???????? 84c0 7410 8d45ec 8b55f4 }
            // n = 7, score = 200
            //   8b45d8               | mov                 eax, dword ptr [ebp - 0x28]
            //   8b15????????         |                     
            //   e8????????           |                     
            //   84c0                 | test                al, al
            //   7410                 | je                  0x12
            //   8d45ec               | lea                 eax, [ebp - 0x14]
            //   8b55f4               | mov                 edx, dword ptr [ebp - 0xc]

        $sequence_3 = { e8???????? 837df800 7460 6a00 }
            // n = 4, score = 200
            //   e8????????           |                     
            //   837df800             | cmp                 dword ptr [ebp - 8], 0
            //   7460                 | je                  0x62
            //   6a00                 | push                0

        $sequence_4 = { 85c0 7405 83e804 8b00 3bd0 7e23 8bc6 }
            // n = 7, score = 200
            //   85c0                 | test                eax, eax
            //   7405                 | je                  7
            //   83e804               | sub                 eax, 4
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   3bd0                 | cmp                 edx, eax
            //   7e23                 | jle                 0x25
            //   8bc6                 | mov                 eax, esi

        $sequence_5 = { 8bc6 e8???????? 8d86b0000000 8b5508 e8???????? c686b400000001 8bc6 }
            // n = 7, score = 200
            //   8bc6                 | mov                 eax, esi
            //   e8????????           |                     
            //   8d86b0000000         | lea                 eax, [esi + 0xb0]
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]
            //   e8????????           |                     
            //   c686b400000001       | mov                 byte ptr [esi + 0xb4], 1
            //   8bc6                 | mov                 eax, esi

        $sequence_6 = { e8???????? 8b55f8 83c9ff 8bc6 e8???????? 663dfa00 7532 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   8b55f8               | mov                 edx, dword ptr [ebp - 8]
            //   83c9ff               | or                  ecx, 0xffffffff
            //   8bc6                 | mov                 eax, esi
            //   e8????????           |                     
            //   663dfa00             | cmp                 ax, 0xfa
            //   7532                 | jne                 0x34

        $sequence_7 = { e8???????? 8b855cffffff e8???????? 50 8d9558ffffff b8???????? e8???????? }
            // n = 7, score = 200
            //   e8????????           |                     
            //   8b855cffffff         | mov                 eax, dword ptr [ebp - 0xa4]
            //   e8????????           |                     
            //   50                   | push                eax
            //   8d9558ffffff         | lea                 edx, [ebp - 0xa8]
            //   b8????????           |                     
            //   e8????????           |                     

        $sequence_8 = { 8bc7 e8???????? 83780c00 7525 46 4b 75ed }
            // n = 7, score = 200
            //   8bc7                 | mov                 eax, edi
            //   e8????????           |                     
            //   83780c00             | cmp                 dword ptr [eax + 0xc], 0
            //   7525                 | jne                 0x27
            //   46                   | inc                 esi
            //   4b                   | dec                 ebx
            //   75ed                 | jne                 0xffffffef

        $sequence_9 = { 8bd8 33c0 8906 6683bbca00000000 }
            // n = 4, score = 200
            //   8bd8                 | mov                 ebx, eax
            //   33c0                 | xor                 eax, eax
            //   8906                 | mov                 dword ptr [esi], eax
            //   6683bbca00000000     | cmp                 word ptr [ebx + 0xca], 0

    condition:
        7 of them and filesize < 7847936
}